/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.model.common;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.mapstruct.ap.internal.model.common.Parameter;
import org.mapstruct.ap.internal.model.common.Type;

public class ParameterBinding {
    private final Type type;
    private final String variableName;
    private final boolean targetType;
    private final boolean mappingTarget;
    private final boolean mappingContext;

    private ParameterBinding(Type parameterType, String variableName, boolean mappingTarget, boolean targetType, boolean mappingContext) {
        this.type = parameterType;
        this.variableName = variableName;
        this.targetType = targetType;
        this.mappingTarget = mappingTarget;
        this.mappingContext = mappingContext;
    }

    public String getVariableName() {
        return this.variableName;
    }

    public boolean isTargetType() {
        return this.targetType;
    }

    public boolean isMappingTarget() {
        return this.mappingTarget;
    }

    public boolean isMappingContext() {
        return this.mappingContext;
    }

    public Type getType() {
        return this.type;
    }

    public Set<Type> getImportTypes() {
        if (this.targetType) {
            return this.type.getImportTypes();
        }
        return Collections.emptySet();
    }

    public static ParameterBinding fromParameter(Parameter parameter) {
        return new ParameterBinding(parameter.getType(), parameter.getName(), parameter.isMappingTarget(), parameter.isTargetType(), parameter.isMappingContext());
    }

    public static List<ParameterBinding> fromParameters(List<Parameter> parameters) {
        ArrayList<ParameterBinding> result = new ArrayList<ParameterBinding>(parameters.size());
        for (Parameter param : parameters) {
            result.add(ParameterBinding.fromParameter(param));
        }
        return result;
    }

    public static ParameterBinding forTargetTypeBinding(Type classTypeOf) {
        return new ParameterBinding(classTypeOf, null, false, true, false);
    }

    public static ParameterBinding forMappingTargetBinding(Type resultType) {
        return new ParameterBinding(resultType, null, true, false, false);
    }

    public static ParameterBinding forSourceTypeBinding(Type sourceType) {
        return new ParameterBinding(sourceType, null, false, false, false);
    }
}

