/*
 * Decompiled with CFR 0.152.
 */
package org.liquibase.maven.plugins;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Map;
import liquibase.Liquibase;
import liquibase.Scope;
import liquibase.command.CommandScope;
import liquibase.configuration.ConfigurationValueProvider;
import liquibase.configuration.LiquibaseConfiguration;
import liquibase.exception.CommandExecutionException;
import liquibase.exception.LiquibaseException;
import org.liquibase.maven.plugins.AbstractLiquibaseMojo;
import org.liquibase.maven.property.PropertyElement;
import org.liquibase.maven.provider.FlowCommandArgumentValueProvider;

public abstract class AbstractLiquibaseFlowMojo
extends AbstractLiquibaseMojo {
    @PropertyElement
    protected String flowFile;
    @PropertyElement
    protected File outputFile;
    @PropertyElement
    protected Map<String, Object> flowCommandArguments;

    @Override
    public boolean databaseConnectionRequired() {
        return false;
    }

    @Override
    protected void performLiquibaseTask(Liquibase liquibase) throws LiquibaseException {
        CommandScope liquibaseCommand = new CommandScope(this.getCommandName());
        liquibaseCommand.addArgumentValue("flowFile", (Object)this.flowFile);
        liquibaseCommand.addArgumentValue("flowIntegration", (Object)"maven");
        if (this.flowCommandArguments != null) {
            FlowCommandArgumentValueProvider flowCommandArgumentValueProvider = new FlowCommandArgumentValueProvider(this.flowCommandArguments);
            ((LiquibaseConfiguration)Scope.getCurrentScope().getSingleton(LiquibaseConfiguration.class)).registerProvider((ConfigurationValueProvider)flowCommandArgumentValueProvider);
        }
        if (this.outputFile != null) {
            try {
                liquibaseCommand.setOutput((OutputStream)new FileOutputStream(this.outputFile));
            }
            catch (FileNotFoundException e) {
                throw new CommandExecutionException((Throwable)e);
            }
        }
        liquibaseCommand.execute();
    }

    public abstract String[] getCommandName();
}

