/*
 * Decompiled with CFR 0.152.
 */
package org.liquibase.maven.plugins;

import java.util.ArrayList;
import liquibase.CatalogAndSchema;
import liquibase.Liquibase;
import liquibase.configuration.HubConfiguration;
import liquibase.configuration.LiquibaseConfiguration;
import liquibase.exception.LiquibaseException;
import org.apache.maven.plugin.MojoFailureException;
import org.liquibase.maven.plugins.AbstractLiquibaseChangeLogMojo;

public class LiquibaseDropAll
extends AbstractLiquibaseChangeLogMojo {
    protected String schemas;
    protected String hubConnectionId;
    protected String catalog;

    @Override
    protected void checkRequiredParametersAreSpecified() throws MojoFailureException {
        HubConfiguration hubConfiguration = (HubConfiguration)LiquibaseConfiguration.getInstance().getConfiguration(HubConfiguration.class);
        String liquibaseHubApiKey = hubConfiguration.getLiquibaseHubApiKey();
        String hubMode = hubConfiguration.getLiquibaseHubMode();
        if (liquibaseHubApiKey != null && !hubMode.toLowerCase().equals("off") && this.hubConnectionId == null && this.changeLogFile == null) {
            String errorMessage = "\nThe dropAll command used with a hub.ApiKey and hub.mode='" + hubMode + "'\ncan send reports to your Hub project. To enable this, please add the \n'--hubConnectionId =<hubConnectionId>' parameter to the CLI, or ensure\na registered changelog file is passed in your defaults file or in the CLI.\nLearn more at https://hub.liquibase.com";
            this.getLog().warn((CharSequence)errorMessage);
        }
    }

    @Override
    protected void performLiquibaseTask(Liquibase liquibase) throws LiquibaseException {
        super.performLiquibaseTask(liquibase);
        try {
            this.checkRequiredParametersAreSpecified();
        }
        catch (Exception e) {
            throw new LiquibaseException((Throwable)e);
        }
        if (this.schemas != null) {
            ArrayList<CatalogAndSchema> schemaObjs = new ArrayList<CatalogAndSchema>();
            for (String name : this.schemas.split(",")) {
                schemaObjs.add(new CatalogAndSchema(this.catalog, name));
            }
            liquibase.dropAll(schemaObjs.toArray(new CatalogAndSchema[schemaObjs.size()]));
        } else {
            liquibase.dropAll();
        }
    }

    @Override
    protected void printSettings(String indent) {
        super.printSettings(indent);
        this.getLog().info((CharSequence)(indent + "schemas: " + this.schemas));
    }
}

