/*
 * Decompiled with CFR 0.152.
 */
package liquibase.command.core.helpers;

import java.net.URI;
import java.net.URISyntaxException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ResourceBundle;
import liquibase.GlobalConfiguration;
import liquibase.Scope;
import liquibase.command.CleanUpCommandStep;
import liquibase.command.CommandResultsBuilder;
import liquibase.command.core.helpers.AbstractHelperCommandStep;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.database.DatabaseFactory;
import liquibase.database.core.DatabaseUtils;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.DatabaseException;
import liquibase.integration.commandline.LiquibaseCommandLineConfiguration;
import liquibase.license.LicenseTrack;
import liquibase.license.LicenseTrackingArgs;
import liquibase.resource.ResourceAccessor;
import liquibase.structure.core.Schema;
import liquibase.util.StringUtil;

public abstract class AbstractDatabaseConnectionCommandStep
extends AbstractHelperCommandStep
implements CleanUpCommandStep {
    public static final String[] COMMAND_NAME = new String[]{"abstractDatabaseConnectionCommandStep"};
    private static final ResourceBundle coreBundle = ResourceBundle.getBundle("liquibase/i18n/liquibase-core");
    private Database database;

    protected Database createDatabaseObject(String url, String username, String password, String defaultSchemaName, String defaultCatalogName, String driver, String driverPropertiesFile, String liquibaseCatalogName, String liquibaseSchemaName) throws DatabaseException {
        ResourceAccessor resourceAccessor = Scope.getCurrentScope().getResourceAccessor();
        String databaseClassName = null;
        Class databaseClass = LiquibaseCommandLineConfiguration.DATABASE_CLASS.getCurrentValue();
        if (databaseClass != null) {
            databaseClassName = databaseClass.getCanonicalName();
        }
        String propertyProviderClass = null;
        Class clazz = LiquibaseCommandLineConfiguration.PROPERTY_PROVIDER_CLASS.getCurrentValue();
        if (clazz != null) {
            propertyProviderClass = clazz.getName();
        }
        String databaseChangeLogTablespaceName = StringUtil.trimToNull(GlobalConfiguration.LIQUIBASE_TABLESPACE_NAME.getCurrentValue());
        String databaseChangeLogLockTableName = StringUtil.trimToNull(GlobalConfiguration.DATABASECHANGELOGLOCK_TABLE_NAME.getCurrentValue());
        String databaseChangeLogTableName = StringUtil.trimToNull(GlobalConfiguration.DATABASECHANGELOG_TABLE_NAME.getCurrentValue());
        try {
            defaultCatalogName = StringUtil.trimToNull(defaultCatalogName);
            defaultSchemaName = StringUtil.trimToNull(defaultSchemaName);
            this.database = DatabaseFactory.getInstance().openDatabase(url, username, password, driver, databaseClassName, driverPropertiesFile, propertyProviderClass, resourceAccessor);
            if (!this.database.supports(Schema.class)) {
                if (defaultSchemaName != null && defaultCatalogName == null) {
                    defaultCatalogName = defaultSchemaName;
                }
                if (liquibaseSchemaName != null && liquibaseCatalogName == null) {
                    liquibaseCatalogName = liquibaseSchemaName;
                }
            }
            defaultCatalogName = StringUtil.trimToNull(defaultCatalogName);
            defaultSchemaName = StringUtil.trimToNull(defaultSchemaName);
            this.database.setDefaultCatalogName(defaultCatalogName);
            this.database.setDefaultSchemaName(defaultSchemaName);
            this.database.setOutputDefaultCatalog(true);
            this.database.setOutputDefaultSchema(true);
            this.database.setLiquibaseCatalogName(liquibaseCatalogName);
            this.database.setLiquibaseTablespaceName(databaseChangeLogTablespaceName);
            this.database.setLiquibaseSchemaName(liquibaseSchemaName);
            if (databaseChangeLogTableName != null) {
                this.database.setDatabaseChangeLogTableName(databaseChangeLogTableName);
                if (databaseChangeLogLockTableName != null) {
                    this.database.setDatabaseChangeLogLockTableName(databaseChangeLogLockTableName);
                } else {
                    this.database.setDatabaseChangeLogLockTableName(databaseChangeLogTableName + "LOCK");
                }
            }
            DatabaseUtils.initializeDatabase(defaultCatalogName, defaultSchemaName, this.database);
        }
        catch (Exception e) {
            throw new DatabaseException(e);
        }
        return this.database;
    }

    @Override
    public void cleanUp(CommandResultsBuilder resultsBuilder) {
        if (this.database != null) {
            try {
                this.database.close();
                this.database = null;
            }
            catch (Exception e) {
                Scope.getCurrentScope().getLog(this.getClass()).warning(coreBundle.getString("problem.closing.connection"), e);
            }
        }
    }

    protected void logLicenseUsage(String url, Database database, boolean isTarget, boolean isReference) {
        if (Boolean.TRUE.equals(LicenseTrackingArgs.ENABLED.getCurrentValue())) {
            try {
                DatabaseConnection connection = database.getConnection();
                Connection underlyingConnection = connection.getUnderlyingConnection();
                String schema = underlyingConnection == null ? null : underlyingConnection.getSchema();
                String catalog = underlyingConnection == null ? null : underlyingConnection.getCatalog();
                String databaseName = database.getDatabaseProductName();
                Scope.getCurrentScope().getLicenseTrackList().getLicenseTracks().add(new LicenseTrack(AbstractDatabaseConnectionCommandStep.removeQueryParameters(JdbcConnection.sanitizeUrl(url, true)), schema, catalog, databaseName, isReference, isTarget));
            }
            catch (URISyntaxException | SQLException e) {
                Scope.getCurrentScope().getLog(this.getClass()).severe("Failed to handle license tracking event", e);
            }
        }
    }

    private static String removeQueryParameters(String jdbcUrl) throws URISyntaxException {
        String jdbcPrefix = "jdbc:";
        boolean startsWithJdbc = jdbcUrl.startsWith(jdbcPrefix);
        Object cleanedUri = jdbcUrl.replaceFirst(jdbcPrefix, "");
        try {
            URI uri = new URI((String)cleanedUri);
            cleanedUri = new URI(uri.getScheme(), uri.getAuthority(), uri.getPath(), null, uri.getFragment()).toString();
        }
        catch (Exception e) {
            cleanedUri = ((String)cleanedUri).split("\\?")[0];
        }
        cleanedUri = ((String)cleanedUri).split("\\;")[0];
        if (startsWithJdbc) {
            cleanedUri = jdbcPrefix + (String)cleanedUri;
        }
        if (((String)cleanedUri).endsWith("/")) {
            cleanedUri = ((String)cleanedUri).substring(0, ((String)cleanedUri).length() - 1);
        }
        return cleanedUri;
    }
}

