/*
 * Decompiled with CFR 0.152.
 */
package liquibase.snapshot;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.SortedSet;
import liquibase.exception.DatabaseException;
import liquibase.snapshot.DatabaseSnapshot;
import liquibase.snapshot.InvalidExampleException;
import liquibase.snapshot.SnapshotGenerator;
import liquibase.snapshot.SnapshotIdService;
import liquibase.structure.DatabaseObject;

public class SnapshotGeneratorChain {
    private Iterator<SnapshotGenerator> snapshotGenerators;
    private final Set<Class<? extends SnapshotGenerator>> replacedGenerators = new HashSet<Class<? extends SnapshotGenerator>>();
    private final SnapshotIdService snapshotIdService = SnapshotIdService.getInstance();

    public SnapshotGeneratorChain(SortedSet<SnapshotGenerator> snapshotGenerators) {
        if (snapshotGenerators != null) {
            this.snapshotGenerators = snapshotGenerators.iterator();
            for (SnapshotGenerator generator : snapshotGenerators) {
                Class<? extends SnapshotGenerator>[] replaces = generator.replaces();
                if (replaces == null || replaces.length <= 0) continue;
                this.replacedGenerators.addAll(Arrays.asList(replaces));
            }
        }
    }

    public <T extends DatabaseObject> T snapshot(T example, DatabaseSnapshot snapshot) throws DatabaseException, InvalidExampleException {
        if (example == null) {
            return null;
        }
        if (snapshot.getDatabase().isSystemObject(example)) {
            return null;
        }
        if (!snapshot.getSnapshotControl().shouldInclude(example.getClass())) {
            return null;
        }
        if (this.snapshotGenerators == null) {
            return null;
        }
        T objectToSnapshot = example;
        while (this.snapshotGenerators.hasNext()) {
            SnapshotGenerator generator = this.snapshotGenerators.next();
            if (this.replacedGenerators.contains(generator.getClass())) continue;
            T object = generator.snapshot(objectToSnapshot, snapshot, this);
            if (object != null && object.getSnapshotId() == null) {
                object.setSnapshotId(this.snapshotIdService.generateId());
            }
            objectToSnapshot = object;
        }
        return objectToSnapshot;
    }
}

