/*
 * Decompiled with CFR 0.152.
 */
package liquibase.parser;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.ResourceBundle;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import liquibase.Labels;
import liquibase.Scope;
import liquibase.change.AbstractSQLChange;
import liquibase.change.Change;
import liquibase.change.core.EmptyChange;
import liquibase.change.core.RawSQLChange;
import liquibase.changelog.ChangeLogParameters;
import liquibase.changelog.ChangeSet;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.changeset.ChangeSetService;
import liquibase.changeset.ChangeSetServiceFactory;
import liquibase.exception.ChangeLogParseException;
import liquibase.parser.ChangeLogParser;
import liquibase.resource.ResourceAccessor;
import liquibase.util.ExceptionUtil;
import liquibase.util.StreamUtil;
import liquibase.util.StringUtil;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractFormattedChangeLogParser
implements ChangeLogParser {
    private static final ResourceBundle coreBundle = ResourceBundle.getBundle("liquibase/i18n/liquibase-core");
    protected static final String EXCEPTION_MESSAGE = coreBundle.getString("formatted.changelog.exception.message");
    public static final String RUN_WITH = "runWith";
    public static final String RUN_WITH_SPOOL_FILE = "runWithSpoolFile";
    public static final String ROLLBACK_END_DELIMITER = "rollbackEndDelimiter";
    public static final String CONTEXT = "context";
    public static final String CONTEXT_FILTER = "contextFilter";
    public static final String LABELS = "labels";
    public static final String LOGICAL_FILE_PATH = "logicalFilePath";
    public static final String IGNORE = "ignore";
    public static final String STRIP_COMMENTS = "stripComments";
    public static final String END_DELIMITER = "endDelimiter";
    public static final String DBMS = "dbms";
    public static final String SPLIT_STATEMENTS = "splitStatements";
    public static final String AUTHOR = "author";
    public static final String ID = "id";
    public static final String CHANGE_SET_PATH = "changeSetPath";
    public static final String PROPERTY_NAME = "propertyName";
    public static final String PROPERTY_VALUE = "propertyValue";
    public static final String PROPERTY_CONTEXT_FILTER = "propertyContextFilter";
    public static final String PROPERTY_CONTEXT = "propertyContext";
    public static final String CHANGE_SET_ID = "changeSetID";
    public static final String CHANGE_SET_AUTHOR = "changeSetAuthor";
    public static final String INCLUDE_ALL = "includeAll";
    public static final String INCLUDE = "include";
    public final String FIRST_LINE_REGEX = String.format("^\\s*%s\\s*liquibase\\s*formatted.*", this.getSingleLineCommentSequence());
    public final Pattern FIRST_LINE_PATTERN = Pattern.compile(this.FIRST_LINE_REGEX, 2);
    public final String PROPERTY_REGEX = String.format("\\s*%s[\\s]*property\\s+(.*:.*)\\s+(.*:.*).*", this.getSingleLineCommentSequence());
    public final Pattern PROPERTY_PATTERN = Pattern.compile(this.PROPERTY_REGEX, 2);
    public final String ALT_PROPERTY_ONE_CHARACTER_REGEX = String.format("\\s*?[%s]+\\s*property\\s.*", this.getSingleLineCommentOneCharacter());
    public final Pattern ALT_PROPERTY_ONE_CHARACTER_PATTERN = Pattern.compile(this.ALT_PROPERTY_ONE_CHARACTER_REGEX, 2);
    public final String CHANGE_SET_REGEX = String.format("\\s*%s[\\s]*changeset\\s+(\"[^\"]+\"|[^:]+):\\s*(\"[^\"]+\"|\\S+).*", this.getSingleLineCommentSequence());
    public final Pattern CHANGE_SET_PATTERN = Pattern.compile(this.CHANGE_SET_REGEX, 2);
    public final String ALT_CHANGE_SET_ONE_CHARACTER_REGEX = String.format("%s[\\s]*changeset\\s.*", this.getSingleLineCommentOneCharacter());
    public final Pattern ALT_CHANGE_SET_ONE_CHARACTER_PATTERN = Pattern.compile(this.ALT_CHANGE_SET_ONE_CHARACTER_REGEX, 2);
    public final String ALT_CHANGE_SET_NO_OTHER_INFO_REGEX = String.format("\\s*%s[\\s]*changeset[\\s]*.*$", this.getSingleLineCommentSequence());
    public final Pattern ALT_CHANGE_SET_NO_OTHER_INFO_PATTERN = Pattern.compile(this.ALT_CHANGE_SET_NO_OTHER_INFO_REGEX, 2);
    public final String ROLLBACK_REGEX = String.format("\\s*%s[\\s]*rollback (.*)", this.getSingleLineCommentSequence());
    public final Pattern ROLLBACK_PATTERN = Pattern.compile(this.ROLLBACK_REGEX, 2);
    public final String ALT_ROLLBACK_ONE_CHARACTER_REGEX = String.format("\\s*%s[\\s]*rollback\\s.*", this.getSingleLineCommentOneCharacter());
    public final Pattern ALT_ROLLBACK_ONE_CHARACTER_PATTERN = Pattern.compile(this.ALT_ROLLBACK_ONE_CHARACTER_REGEX, 2);
    public final String PRECONDITIONS_REGEX = String.format("\\s*%s[\\s]*preconditions(.*)", this.getSingleLineCommentSequence());
    public final Pattern PRECONDITIONS_PATTERN = Pattern.compile(this.PRECONDITIONS_REGEX, 2);
    public final String ALT_PRECONDITIONS_ONE_CHARACTER_REGEX = String.format("\\s*%s[\\s]*preconditions\\s.*", this.getSingleLineCommentOneCharacter());
    public final Pattern ALT_PRECONDITIONS_ONE_CHARACTER_PATTERN = Pattern.compile(this.ALT_PRECONDITIONS_ONE_CHARACTER_REGEX, 2);
    public final String PRECONDITION_REGEX = String.format("\\s*%s[\\s]*precondition\\-([a-zA-Z0-9-]+) (.*)", this.getSingleLineCommentSequence());
    public final Pattern PRECONDITION_PATTERN = Pattern.compile(this.PRECONDITION_REGEX, 2);
    public final String INVALID_EMPTY_PRECONDITION_REGEX = String.format("\\s*%s[\\s]*precondition\\-([a-zA-Z0-9-]+)", this.getSingleLineCommentSequence());
    public final Pattern INVALID_EMPTY_PRECONDITION_PATTERN = Pattern.compile(this.INVALID_EMPTY_PRECONDITION_REGEX, 2);
    public final String ALT_PRECONDITION_ONE_CHARACTER_REGEX = String.format("\\s*%s[\\s]*precondition(.*)", this.getSingleLineCommentOneCharacter());
    public final Pattern ALT_PRECONDITION_ONE_CHARACTER_PATTERN = Pattern.compile(this.ALT_PRECONDITION_ONE_CHARACTER_REGEX, 2);
    public static final String STRIP_COMMENTS_REGEX = ".*stripComments:(\\w+).*";
    public static final Pattern STRIP_COMMENTS_PATTERN = Pattern.compile(".*stripComments:(\\w+).*", 2);
    public static final String SPLIT_STATEMENTS_REGEX = ".*splitStatements:(\\w+).*";
    public static final Pattern SPLIT_STATEMENTS_PATTERN = Pattern.compile(".*splitStatements:(\\w+).*", 2);
    public static final String ROLLBACK_SPLIT_STATEMENTS_REGEX = ".*rollbackSplitStatements:(\\w+).*";
    public static final Pattern ROLLBACK_SPLIT_STATEMENTS_PATTERN = Pattern.compile(".*rollbackSplitStatements:(\\w+).*", 2);
    public static final String END_DELIMITER_REGEX = ".*\\bendDelimiter:(\\S*).*";
    public static final Pattern END_DELIMITER_PATTERN = Pattern.compile(".*\\bendDelimiter:(\\S*).*", 2);
    public static final String ROLLBACK_END_DELIMITER_REGEX = ".*\\brollbackEndDelimiter:(\\S*).*";
    public static final Pattern ROLLBACK_END_DELIMITER_PATTERN = Pattern.compile(".*\\brollbackEndDelimiter:(\\S*).*", 2);
    public final String COMMENT_REGEX = String.format("%s[\\s]*comment:? (.*)", this.getSingleLineCommentSequence());
    public final Pattern COMMENT_PATTERN = Pattern.compile(this.COMMENT_REGEX, 2);
    public final String ALT_COMMENT_PLURAL_REGEX = String.format("%s[\\s]*comments:? (.*)", this.getSingleLineCommentSequence());
    public final Pattern ALT_COMMENT_PLURAL_PATTERN = Pattern.compile(this.ALT_COMMENT_PLURAL_REGEX, 2);
    public final String ALT_COMMENT_ONE_CHARACTER_REGEX = String.format("%s[\\s]*comment:? (.*)", this.getSingleLineCommentOneCharacter());
    public final Pattern ALT_COMMENT_ONE_CHARACTER_PATTERN = Pattern.compile(this.ALT_COMMENT_ONE_CHARACTER_REGEX, 2);
    public final String VALID_CHECK_SUM_REGEX = String.format("%s[\\s]*validCheckSum:? (.*)", this.getSingleLineCommentSequence());
    public final Pattern VALID_CHECK_SUM_PATTERN = Pattern.compile(this.VALID_CHECK_SUM_REGEX, 2);
    public final String ALT_VALID_CHECK_SUM_ONE_CHARACTER_REGEX = String.format("^%s[\\s]*validCheckSum(.*)$", this.getSingleLineCommentOneCharacter());
    public final Pattern ALT_VALID_CHECK_SUM_ONE_CHARACTER_PATTERN = Pattern.compile(this.ALT_VALID_CHECK_SUM_ONE_CHARACTER_REGEX, 2);
    public final String IGNORE_LINES_REGEX = String.format("%s[\\s]*ignoreLines:(\\w+)", this.getSingleLineCommentSequence());
    public final Pattern IGNORE_LINES_PATTERN = Pattern.compile(this.IGNORE_LINES_REGEX, 2);
    public final String ALT_IGNORE_LINES_ONE_CHARACTER_REGEX = String.format("%s[\\s]*?ignoreLines:(\\w+).*$", this.getSingleLineCommentOneCharacter());
    public final Pattern ALT_IGNORE_LINES_ONE_CHARACTER_PATTERN = Pattern.compile(this.ALT_IGNORE_LINES_ONE_CHARACTER_REGEX, 2);
    public final String ALT_IGNORE_REGEX = String.format("%s[\\s]*ignore:(\\w+)", this.getSingleLineCommentSequence());
    public final Pattern ALT_IGNORE_PATTERN = Pattern.compile(this.ALT_IGNORE_REGEX, 2);
    public static final String RUN_WITH_REGEX = ".*runWith:([\\w\\$\\{\\}]+).*";
    public static final Pattern RUN_WITH_PATTERN = Pattern.compile(".*runWith:([\\w\\$\\{\\}]+).*", 2);
    public static final String RUN_WITH_SPOOL_FILE_REGEX = ".*runWithSpoolFile:(.*).*";
    public static final Pattern RUN_WITH_SPOOL_FILE_PATTERN = Pattern.compile(".*runWithSpoolFile:(.*).*", 2);
    public static final String RUN_ON_CHANGE_REGEX = ".*runOnChange:(\\w+).*";
    public static final Pattern RUN_ON_CHANGE_PATTERN = Pattern.compile(".*runOnChange:(\\w+).*", 2);
    public static final String RUN_ALWAYS_REGEX = ".*runAlways:(\\w+).*";
    public static final Pattern RUN_ALWAYS_PATTERN = Pattern.compile(".*runAlways:(\\w+).*", 2);
    public static final String CONTEXT_REGEX = ".*context:(\".*?\"|\\S*).*";
    public static final Pattern CONTEXT_PATTERN = Pattern.compile(".*context:(\".*?\"|\\S*).*", 2);
    public static final String CONTEXT_FILTER_REGEX = ".*contextFilter:(\".*?\"|\\S*).*";
    public static final Pattern CONTEXT_FILTER_PATTERN = Pattern.compile(".*contextFilter:(\".*?\"|\\S*).*", 2);
    public static final String LOGICAL_FILE_PATH_REGEX = ".*logicalFilePath:(\\S*).*";
    public static final Pattern LOGICAL_FILE_PATH_PATTERN = Pattern.compile(".*logicalFilePath:(\\S*).*", 2);
    public static final String LABELS_REGEX = ".*labels:(\".*?\"|\\S*).*";
    public static final Pattern LABELS_PATTERN = Pattern.compile(".*labels:(\".*?\"|\\S*).*", 2);
    public static final String RUN_IN_TRANSACTION_REGEX = ".*runInTransaction:(\\w+).*";
    public static final Pattern RUN_IN_TRANSACTION_PATTERN = Pattern.compile(".*runInTransaction:(\\w+).*", 2);
    public static final String DBMS_REGEX = ".*dbms:([^,][\\w!,]+).*";
    public static final Pattern DBMS_PATTERN = Pattern.compile(".*dbms:([^,][\\w!,]+).*", 2);
    public static final String IGNORE_REGEX = ".*ignore:(\\w*).*";
    public static final Pattern IGNORE_PATTERN = Pattern.compile(".*ignore:(\\w*).*", 2);
    public static final String FAIL_ON_ERROR_REGEX = ".*failOnError:(\\w+).*";
    public static final Pattern FAIL_ON_ERROR_PATTERN = Pattern.compile(".*failOnError:(\\w+).*", 2);
    public static final String ON_FAIL_REGEX = ".*onFail:(\\w+).*";
    public static final Pattern ON_FAIL_PATTERN = Pattern.compile(".*onFail:(\\w+).*", 2);
    public static final String ON_ERROR_REGEX = ".*onError:(\\w+).*";
    public static final Pattern ON_ERROR_PATTERN = Pattern.compile(".*onError:(\\w+).*", 2);
    public static final String ROLLBACK_CHANGE_SET_ID_REGEX = ".*changeSetId:(\\S+).*";
    public static final Pattern ROLLBACK_CHANGE_SET_ID_PATTERN = Pattern.compile(".*changeSetId:(\\S+).*", 2);
    public static final String ROLLBACK_CHANGE_SET_AUTHOR_REGEX = ".*changesetAuthor:(\\S+).*";
    public static final Pattern ROLLBACK_CHANGE_SET_AUTHOR_PATTERN = Pattern.compile(".*changesetAuthor:(\\S+).*", 2);
    public static final String ROLLBACK_CHANGE_SET_PATH_REGEX = ".*changesetPath:(\\S+).*";
    public static final Pattern ROLLBACK_CHANGE_SET_PATH_PATTERN = Pattern.compile(".*changesetPath:(\\S+).*", 2);
    public final String ROLLBACK_MULTI_LINE_START_REGEX = String.format("\\s*%s\\s*liquibase\\s*rollback\\s*$", this.getStartMultiLineCommentSequence());
    public final Pattern ROLLBACK_MULTI_LINE_START_PATTERN = Pattern.compile(this.ROLLBACK_MULTI_LINE_START_REGEX, 2);
    public final String ROLLBACK_MULTI_LINE_END_REGEX = String.format(".*\\s*%s\\s*$", this.getEndMultiLineCommentSequence());
    public final Pattern ROLLBACK_MULTI_LINE_END_PATTERN = Pattern.compile(this.ROLLBACK_MULTI_LINE_END_REGEX, 2);
    public static final String WORD_RESULT_REGEX = "^(?:expectedResult:)?(\\w+) (.*)";
    public static final String SINGLE_QUOTE_RESULT_REGEX = "^(?:expectedResult:)?'([^']+)' (.*)";
    public static final String DOUBLE_QUOTE_RESULT_REGEX = "^(?:expectedResult:)?\"([^\"]+)\" (.*)";
    public static final Pattern[] WORD_AND_QUOTING_PATTERNS = new Pattern[]{Pattern.compile("^(?:expectedResult:)?(\\w+) (.*)", 2), Pattern.compile("^(?:expectedResult:)?'([^']+)' (.*)", 2), Pattern.compile("^(?:expectedResult:)?\"([^\"]+)\" (.*)", 2)};
    public static final String NAME_REGEX = ".*name:\\s*(\\S++).*";
    public static final Pattern NAME_PATTERN = Pattern.compile(".*name:\\s*(\\S++).*", 2);
    public static final String VALUE_REGEX = ".*value:\\s*(\\S+).*";
    public static final Pattern VALUE_PATTERN = Pattern.compile(".*value:\\s*(\\S+).*", 2);
    public static final String GLOBAL_REGEX = ".*global:(\\S+).*";
    public static final Pattern GLOBAL_PATTERN = Pattern.compile(".*global:(\\S+).*", 2);
    public static final String VIEW_NAME_STATEMENT_REGEX = ".*view:(\\w+).*";
    public static final Pattern VIEW_NAME_STATEMENT_PATTERN = Pattern.compile(".*view:(\\w+).*", 2);
    public static final String TABLE_NAME_STATEMENT_REGEX = ".*table:(\\w+).*";
    public static final Pattern TABLE_NAME_STATEMENT_PATTERN = Pattern.compile(".*table:(\\w+).*", 2);
    public static final String SCHEMA_NAME_STATEMENT_REGEX = ".*schema:(\\w+).*";
    public static final Pattern SCHEMA_NAME_STATEMENT_PATTERN = Pattern.compile(".*schema:(\\w+).*", 2);

    protected abstract String getSingleLineCommentOneCharacter();

    protected abstract String getSingleLineCommentSequence();

    protected abstract String getStartMultiLineCommentSequence();

    protected abstract String getEndMultiLineCommentSequence();

    protected abstract boolean supportsExtension(String var1);

    protected abstract void handlePreconditionCase(ChangeLogParameters var1, ChangeSet var2, Matcher var3) throws ChangeLogParseException;

    protected abstract void handlePreconditionsCase(ChangeSet var1, int var2, Matcher var3) throws ChangeLogParseException;

    protected abstract AbstractSQLChange getChange();

    protected abstract String getDocumentationLink();

    protected abstract String getSequenceName();

    protected abstract void setChangeSequence(AbstractSQLChange var1, String var2);

    protected abstract boolean isNotEndDelimiter(AbstractSQLChange var1);

    protected abstract void setChangeSequence(ChangeLogParameters var1, StringBuilder var2, ChangeSet var3, AbstractSQLChange var4);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean supports(String changeLogFile, ResourceAccessor resourceAccessor) {
        BufferedReader reader = null;
        try {
            if (this.supportsExtension(changeLogFile)) {
                InputStream fileStream = this.openChangeLogFile(changeLogFile, resourceAccessor);
                if (fileStream == null) {
                    boolean bl = false;
                    return bl;
                }
                reader = new BufferedReader(StreamUtil.readStreamWithReader(fileStream, null));
                String firstLine = reader.readLine();
                while (firstLine != null && firstLine.trim().isEmpty() && reader.ready()) {
                    firstLine = reader.readLine();
                }
                if (StringUtils.isEmpty((CharSequence)firstLine)) {
                    Scope.getCurrentScope().getLog(this.getClass()).warning(String.format("Skipping empty file '%s'", changeLogFile));
                    boolean e = false;
                    return e;
                }
                boolean e = this.FIRST_LINE_PATTERN.matcher(firstLine).matches();
                return e;
            }
            boolean fileStream = false;
            return fileStream;
        }
        catch (IOException e) {
            Scope.getCurrentScope().getLog(this.getClass()).fine("Exception reading " + changeLogFile, e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    Scope.getCurrentScope().getLog(this.getClass()).fine("Exception closing " + changeLogFile, e);
                }
            }
        }
    }

    @Override
    public int getPriority() {
        return 6;
    }

    @Override
    public DatabaseChangeLog parse(String physicalChangeLogLocation, ChangeLogParameters changeLogParameters, ResourceAccessor resourceAccessor) throws ChangeLogParseException {
        DatabaseChangeLog changeLog = new DatabaseChangeLog();
        changeLog.setChangeLogParameters(changeLogParameters);
        changeLog.setPhysicalFilePath(physicalChangeLogLocation);
        ExceptionUtil.doSilently(() -> Scope.getCurrentScope().getAnalyticsEvent().incrementFormattedSqlChangelogCount());
        try (BufferedReader reader = new BufferedReader(StreamUtil.readStreamWithReader(this.openChangeLogFile(physicalChangeLogLocation, resourceAccessor), null));){
            String line;
            StringBuilder currentSequence = new StringBuilder();
            StringBuilder currentRollbackSequence = new StringBuilder();
            ChangeSet changeSet = null;
            AbstractSQLChange change = null;
            Matcher rollbackSplitStatementsPatternMatcher = null;
            boolean rollbackSplitStatements = true;
            String rollbackEndDelimiter = null;
            int count = 0;
            block9: while ((line = reader.readLine()) != null) {
                String message;
                String message2;
                ++count;
                Matcher commentMatcher = this.COMMENT_PATTERN.matcher(line);
                Matcher propertyPatternMatcher = this.PROPERTY_PATTERN.matcher(line);
                Matcher altPropertyPatternMatcher = this.ALT_PROPERTY_ONE_CHARACTER_PATTERN.matcher(line);
                if (propertyPatternMatcher.matches()) {
                    this.handleProperty(changeLogParameters, changeLog, line);
                    continue;
                }
                if (altPropertyPatternMatcher.matches()) {
                    String message3 = String.format(EXCEPTION_MESSAGE, physicalChangeLogLocation, count, this.getSequenceName(), "--property name=<property name> value=<property value>", this.getDocumentationLink());
                    throw new ChangeLogParseException("\n" + message3);
                }
                Matcher changeLogPatterMatcher = this.FIRST_LINE_PATTERN.matcher(line);
                this.setLogicalFilePath(changeLog, line, changeLogPatterMatcher);
                Matcher ignoreLinesMatcher = this.IGNORE_LINES_PATTERN.matcher(line);
                Matcher altIgnoreMatcher = this.ALT_IGNORE_PATTERN.matcher(line);
                Matcher altIgnoreLinesOneDashMatcher = this.ALT_IGNORE_LINES_ONE_CHARACTER_PATTERN.matcher(line);
                if (ignoreLinesMatcher.matches()) {
                    if ("start".equals(ignoreLinesMatcher.group(1))) {
                        while ((line = reader.readLine()) != null) {
                            altIgnoreLinesOneDashMatcher = this.ALT_IGNORE_LINES_ONE_CHARACTER_PATTERN.matcher(line);
                            ++count;
                            ignoreLinesMatcher = this.IGNORE_LINES_PATTERN.matcher(line);
                            if (ignoreLinesMatcher.matches()) {
                                if (!"end".equals(ignoreLinesMatcher.group(1))) continue;
                                continue block9;
                            }
                            if (!altIgnoreLinesOneDashMatcher.matches()) continue;
                            message2 = String.format(EXCEPTION_MESSAGE, physicalChangeLogLocation, count, this.getSequenceName(), "--ignoreLines:end", this.getDocumentationLink());
                            throw new ChangeLogParseException("\n" + message2);
                        }
                        continue;
                    }
                    String ignoreCountAttribute = ignoreLinesMatcher.group(1);
                    try {
                        long ignoreCount = Long.parseLong(ignoreCountAttribute);
                        while (ignoreCount > 0L && reader.readLine() != null) {
                            --ignoreCount;
                            ++count;
                        }
                        continue;
                    }
                    catch (NullPointerException | NumberFormatException nfe) {
                        throw new ChangeLogParseException(String.format("Unknown ignoreLines syntax: \"%s\"", ignoreCountAttribute), nfe);
                    }
                }
                if (altIgnoreLinesOneDashMatcher.matches() || altIgnoreMatcher.matches()) {
                    message2 = String.format(EXCEPTION_MESSAGE, physicalChangeLogLocation, count, this.getSequenceName(), "--ignoreLines:<count|start>", this.getDocumentationLink());
                    throw new ChangeLogParseException("\n" + message2);
                }
                Matcher changeSetPatternMatcher = this.CHANGE_SET_PATTERN.matcher(line);
                if (changeSetPatternMatcher.matches()) {
                    String logicalFilePath;
                    String labels;
                    String runWithSpoolFile;
                    String finalCurrentSequence = changeLogParameters.expandExpressions(StringUtil.trimToNull(currentSequence.toString()), changeLog);
                    if (changeSet != null) {
                        if (finalCurrentSequence == null) {
                            throw new ChangeLogParseException(String.format("No %s for changeset %s", this.getSequenceName(), changeSet.toString(false)));
                        }
                        this.setChangeSequence(change, finalCurrentSequence);
                        if (change instanceof RawSQLChange) {
                            ((RawSQLChange)change).setSqlEndLine(count - 1);
                        }
                        this.handleRollbackSequence(physicalChangeLogLocation, changeLogParameters, changeLog, currentRollbackSequence, changeSet, rollbackSplitStatementsPatternMatcher, rollbackSplitStatements, rollbackEndDelimiter);
                    }
                    Matcher runWithMatcher = RUN_WITH_PATTERN.matcher(line);
                    Matcher runWithSpoolFileMatcher = RUN_WITH_SPOOL_FILE_PATTERN.matcher(line);
                    rollbackSplitStatementsPatternMatcher = ROLLBACK_SPLIT_STATEMENTS_PATTERN.matcher(line);
                    Matcher rollbackEndDelimiterPatternMatcher = ROLLBACK_END_DELIMITER_PATTERN.matcher(line);
                    Matcher logicalFilePathMatcher = LOGICAL_FILE_PATH_PATTERN.matcher(line);
                    Matcher runOnChangePatternMatcher = RUN_ON_CHANGE_PATTERN.matcher(line);
                    Matcher runAlwaysPatternMatcher = RUN_ALWAYS_PATTERN.matcher(line);
                    Matcher contextPatternMatcher = CONTEXT_PATTERN.matcher(line);
                    Matcher contextFilterPatternMatcher = CONTEXT_FILTER_PATTERN.matcher(line);
                    Matcher labelsPatternMatcher = LABELS_PATTERN.matcher(line);
                    Matcher runInTransactionPatternMatcher = RUN_IN_TRANSACTION_PATTERN.matcher(line);
                    Matcher ignorePatternMatcher = IGNORE_PATTERN.matcher(line);
                    Matcher failOnErrorPatternMatcher = FAIL_ON_ERROR_PATTERN.matcher(line);
                    rollbackSplitStatements = this.parseBoolean(rollbackSplitStatementsPatternMatcher, changeSet, true, "rollbackSplitStatements");
                    boolean runOnChange = this.parseBoolean(runOnChangePatternMatcher, changeSet, false, "runOnChange");
                    boolean runAlways = this.parseBoolean(runAlwaysPatternMatcher, changeSet, false, "runAlways");
                    boolean runInTransaction = this.parseBoolean(runInTransactionPatternMatcher, changeSet, true, "runInTransaction");
                    boolean failOnError = this.parseBoolean(failOnErrorPatternMatcher, changeSet, true, "failOnError");
                    String runWith = this.parseString(runWithMatcher, RUN_WITH);
                    if (runWith != null) {
                        runWith = changeLogParameters.expandExpressions(runWith, changeLog);
                    }
                    if ((runWithSpoolFile = this.parseString(runWithSpoolFileMatcher, RUN_WITH_SPOOL_FILE)) != null) {
                        runWithSpoolFile = changeLogParameters.expandExpressions(runWithSpoolFile, changeLog);
                    }
                    rollbackEndDelimiter = this.parseString(rollbackEndDelimiterPatternMatcher, ROLLBACK_END_DELIMITER);
                    String context = this.parseString(contextFilterPatternMatcher, CONTEXT_FILTER);
                    if (context == null || context.isEmpty()) {
                        context = this.parseString(contextPatternMatcher, CONTEXT);
                    }
                    if (context != null) {
                        context = changeLogParameters.expandExpressions(StringUtil.stripEnclosingQuotes(context), changeLog);
                    }
                    if ((labels = this.parseString(labelsPatternMatcher, LABELS)) != null) {
                        labels = changeLogParameters.expandExpressions(StringUtil.stripEnclosingQuotes(labels), changeLog);
                    }
                    if ((logicalFilePath = this.parseString(logicalFilePathMatcher, LOGICAL_FILE_PATH)) == null || logicalFilePath.isEmpty()) {
                        logicalFilePath = changeLog.getLogicalFilePath();
                    }
                    if (logicalFilePath != null) {
                        logicalFilePath = changeLogParameters.expandExpressions(logicalFilePath, changeLog);
                    }
                    String dbms = this.handleDbms(changeLogParameters, line, changeLog);
                    String ignore = this.parseString(ignorePatternMatcher, IGNORE);
                    if (ignore != null) {
                        ignore = changeLogParameters.expandExpressions(ignore, changeLog);
                    }
                    String idGroup = changeSetPatternMatcher.group(2);
                    String authorGroup = changeSetPatternMatcher.group(1);
                    Pattern changeSetAuthorIdPattern = Pattern.compile(String.format("\\s*%s[\\s]*changeset\\s+", this.getSingleLineCommentSequence()) + Pattern.quote(authorGroup + ":" + idGroup) + ".*$", 2);
                    Matcher changeSetAuthorIdPatternMatcher = changeSetAuthorIdPattern.matcher(line);
                    if (!changeSetAuthorIdPatternMatcher.matches()) {
                        String message4 = String.format(EXCEPTION_MESSAGE, physicalChangeLogLocation, count, this.getSequenceName(), "--changeset <authorname>:<changesetId>", this.getDocumentationLink());
                        throw new ChangeLogParseException("\n" + message4);
                    }
                    String changeSetId = changeLogParameters.expandExpressions(StringUtil.stripEnclosingQuotes(idGroup), changeLog);
                    this.validateChangeSetId(changeSetId, line, count);
                    String changeSetAuthor = changeLogParameters.expandExpressions(StringUtil.stripEnclosingQuotes(authorGroup), changeLog);
                    this.logMatch(CHANGE_SET_AUTHOR, changeSetAuthor, AbstractFormattedChangeLogParser.class);
                    changeSet = this.configureChangeSet(changeLog, runOnChange, runAlways, runInTransaction, failOnError, runWith, runWithSpoolFile, context, labels, logicalFilePath, dbms, ignore, changeSetId, changeSetAuthor);
                    changeLog.addChangeSet(changeSet);
                    change = this.getChange();
                    this.setChangeSequence(change, finalCurrentSequence);
                    this.handleSplitStatements(line, changeSet, change);
                    this.handleStripComments(line, changeSet, change);
                    this.handleEndDelimiter(line, change);
                    changeSet.addChange(change);
                    AbstractFormattedChangeLogParser.resetSequences(currentSequence, currentRollbackSequence);
                    continue;
                }
                Matcher altChangeSetOneDashPatternMatcher = this.ALT_CHANGE_SET_ONE_CHARACTER_PATTERN.matcher(line);
                Matcher altChangeSetNoOtherInfoPatternMatcher = this.ALT_CHANGE_SET_NO_OTHER_INFO_PATTERN.matcher(line);
                if (altChangeSetOneDashPatternMatcher.matches() || altChangeSetNoOtherInfoPatternMatcher.matches()) {
                    message = String.format(EXCEPTION_MESSAGE, physicalChangeLogLocation, count, this.getSequenceName(), "--changeset <authorname>:<changesetId>", this.getDocumentationLink());
                    throw new ChangeLogParseException("\n" + message);
                }
                if (changeSet != null) {
                    AtomicBoolean changeSetFinished = new AtomicBoolean(false);
                    this.configureChangeSet(physicalChangeLogLocation, changeLogParameters, reader, currentSequence, currentRollbackSequence, changeSet, count, line, commentMatcher, resourceAccessor, changeLog, change, rollbackSplitStatementsPatternMatcher, rollbackSplitStatements, rollbackEndDelimiter, changeSetFinished);
                    if (!changeSetFinished.get()) continue;
                    changeSet = null;
                    continue;
                }
                if (commentMatcher.matches()) {
                    message = String.format("Unexpected formatting at line %d. Formatted %s changelogs do not allow comment lines outside of changesets. Learn all the options at %s", count, this.getSequenceName(), this.getDocumentationLink());
                    throw new ChangeLogParseException("\n" + message);
                }
                this.handleAdditionalLines(changeLog, resourceAccessor, line);
            }
            if (currentSequence.length() > 0) {
                this.handleChangeSet(physicalChangeLogLocation, changeLogParameters, changeSet, currentSequence, change, changeLog, currentRollbackSequence, rollbackSplitStatementsPatternMatcher, rollbackSplitStatements, rollbackEndDelimiter);
                if (change instanceof RawSQLChange) {
                    ((RawSQLChange)change).setSqlEndLine(count);
                }
            }
        }
        catch (IOException e) {
            throw new ChangeLogParseException(e);
        }
        return changeLog;
    }

    protected void handleChangeSet(String physicalChangeLogLocation, ChangeLogParameters changeLogParameters, ChangeSet changeSet, StringBuilder currentSequence, AbstractSQLChange change, DatabaseChangeLog changeLog, StringBuilder currentRollbackSequence, Matcher rollbackSplitStatementsPatternMatcher, boolean rollbackSplitStatements, String rollbackEndDelimiter) throws ChangeLogParseException {
        if (changeSet != null) {
            this.setChangeSequence(changeLogParameters, currentSequence, changeSet, change);
            if (this.isNotEndDelimiter(change)) {
                change.setEndDelimiter("\n/$");
            }
            this.handleRollbackSequence(physicalChangeLogLocation, changeLogParameters, changeLog, currentRollbackSequence, changeSet, rollbackSplitStatementsPatternMatcher, rollbackSplitStatements, rollbackEndDelimiter);
        }
    }

    protected void handleStripComments(String line, ChangeSet changeSet, AbstractSQLChange change) throws ChangeLogParseException {
        Matcher stripCommentsPatternMatcher = STRIP_COMMENTS_PATTERN.matcher(line);
        boolean stripComments = this.parseBoolean(stripCommentsPatternMatcher, changeSet, true, STRIP_COMMENTS);
        change.setStripComments(stripComments, !stripCommentsPatternMatcher.matches());
    }

    protected void handleEndDelimiter(String line, AbstractSQLChange change) {
        Matcher endDelimiterPatternMatcher = END_DELIMITER_PATTERN.matcher(line);
        String endDelimiter = this.parseString(endDelimiterPatternMatcher, END_DELIMITER);
        change.setEndDelimiter(endDelimiter);
    }

    protected String handleDbms(ChangeLogParameters changeLogParameters, String line, DatabaseChangeLog changeLog) {
        Matcher dbmsPatternMatcher = DBMS_PATTERN.matcher(line);
        String dbms = this.parseString(dbmsPatternMatcher, DBMS);
        if (dbms != null) {
            dbms = changeLogParameters.expandExpressions(dbms, changeLog);
        }
        return dbms;
    }

    protected void handleSplitStatements(String line, ChangeSet changeSet, AbstractSQLChange change) throws ChangeLogParseException {
        Matcher splitStatementsPatternMatcher = SPLIT_STATEMENTS_PATTERN.matcher(line);
        boolean splitStatements = this.parseBoolean(splitStatementsPatternMatcher, changeSet, true, SPLIT_STATEMENTS);
        if (splitStatementsPatternMatcher.matches()) {
            change.setSplitStatements(splitStatements);
        }
    }

    @Deprecated
    protected void configureChangeSet(String physicalChangeLogLocation, ChangeLogParameters changeLogParameters, BufferedReader reader, StringBuilder currentSequence, StringBuilder currentRollbackSequence, ChangeSet changeSet, int count, String line, Matcher commentMatcher) throws ChangeLogParseException, IOException {
        this.configureChangeSet(physicalChangeLogLocation, changeLogParameters, reader, currentSequence, currentRollbackSequence, changeSet, count, line, commentMatcher, null);
    }

    protected void configureChangeSet(String physicalChangeLogLocation, ChangeLogParameters changeLogParameters, BufferedReader reader, StringBuilder currentSequence, StringBuilder currentRollbackSequence, ChangeSet changeSet, int count, String line, Matcher commentMatcher, ResourceAccessor resourceAccessor) throws ChangeLogParseException, IOException {
        this.configureChangeSet(physicalChangeLogLocation, changeLogParameters, reader, currentSequence, currentRollbackSequence, changeSet, count, line, commentMatcher, resourceAccessor, null, null, null, false, null, new AtomicBoolean(false));
    }

    protected void configureChangeSet(String physicalChangeLogLocation, ChangeLogParameters changeLogParameters, BufferedReader reader, StringBuilder currentSequence, StringBuilder currentRollbackSequence, ChangeSet changeSet, int count, String line, Matcher commentMatcher, ResourceAccessor resourceAccessor, DatabaseChangeLog changeLog, AbstractSQLChange change, Matcher rollbackSplitStatementsMatcher, boolean rollbackSplitStatements, String rollbackEndDelimiter, AtomicBoolean changeSetFinished) throws ChangeLogParseException, IOException {
        Matcher altCommentOneDashMatcher = this.ALT_COMMENT_ONE_CHARACTER_PATTERN.matcher(line);
        Matcher altCommentPluralMatcher = this.ALT_COMMENT_PLURAL_PATTERN.matcher(line);
        Matcher rollbackMatcher = this.ROLLBACK_PATTERN.matcher(line);
        Matcher altRollbackMatcher = this.ALT_ROLLBACK_ONE_CHARACTER_PATTERN.matcher(line);
        Matcher preconditionsMatcher = this.PRECONDITIONS_PATTERN.matcher(line);
        Matcher altPreconditionsOneDashMatcher = this.ALT_PRECONDITIONS_ONE_CHARACTER_PATTERN.matcher(line);
        Matcher preconditionMatcher = this.PRECONDITION_PATTERN.matcher(line);
        Matcher altPreconditionOneDashMatcher = this.ALT_PRECONDITION_ONE_CHARACTER_PATTERN.matcher(line);
        Matcher validCheckSumMatcher = this.VALID_CHECK_SUM_PATTERN.matcher(line);
        Matcher altValidCheckSumOneDashMatcher = this.ALT_VALID_CHECK_SUM_ONE_CHARACTER_PATTERN.matcher(line);
        Matcher rollbackMultiLineStartMatcher = this.ROLLBACK_MULTI_LINE_START_PATTERN.matcher(line);
        Matcher invalidEmptyPreconditionMatcher = this.INVALID_EMPTY_PRECONDITION_PATTERN.matcher(line);
        if (commentMatcher.matches()) {
            if (commentMatcher.groupCount() == 0) {
                String message = String.format(EXCEPTION_MESSAGE, physicalChangeLogLocation, count, this.getSequenceName(), "--comment <comment>", this.getDocumentationLink());
                throw new ChangeLogParseException("\n" + message);
            }
            if (commentMatcher.groupCount() == 1) {
                changeSet.setComments(commentMatcher.group(1));
            }
            Scope.getCurrentScope().getLog(this.getClass()).fine("Matched comment '" + changeSet.getComments() + "'");
        } else {
            if (altCommentOneDashMatcher.matches() || altCommentPluralMatcher.matches()) {
                String message = String.format(EXCEPTION_MESSAGE, physicalChangeLogLocation, count, this.getSequenceName(), "--comment <comment>", this.getDocumentationLink());
                throw new ChangeLogParseException("\n" + message);
            }
            if (validCheckSumMatcher.matches()) {
                if (validCheckSumMatcher.groupCount() == 0) {
                    String message = String.format(EXCEPTION_MESSAGE, physicalChangeLogLocation, count, this.getSequenceName(), String.format("--rollback <rollback %s>", this.getSequenceName()), this.getDocumentationLink());
                    throw new ChangeLogParseException("\n" + message);
                }
                if (validCheckSumMatcher.groupCount() == 1) {
                    changeSet.addValidCheckSum(validCheckSumMatcher.group(1));
                }
                Scope.getCurrentScope().getLog(this.getClass()).fine("Matched validChecksum '" + changeSet.getValidCheckSums() + "'");
            } else {
                if (altValidCheckSumOneDashMatcher.matches()) {
                    String message = String.format(EXCEPTION_MESSAGE, physicalChangeLogLocation, count, this.getSequenceName(), "--validChecksum <checksum>", this.getDocumentationLink());
                    throw new ChangeLogParseException("\n" + message);
                }
                if (rollbackMatcher.matches()) {
                    if (rollbackMatcher.groupCount() == 0) {
                        String message = String.format(EXCEPTION_MESSAGE, physicalChangeLogLocation, count, this.getSequenceName(), String.format("--rollback <rollback %s>", this.getSequenceName()), this.getDocumentationLink());
                        throw new ChangeLogParseException("\n" + message);
                    }
                    Scope.getCurrentScope().getLog(this.getClass()).fine("Matched rollback");
                    currentRollbackSequence.append(rollbackMatcher.group(1)).append(System.lineSeparator());
                } else {
                    if (altRollbackMatcher.matches()) {
                        String message = String.format(EXCEPTION_MESSAGE, physicalChangeLogLocation, count, this.getSequenceName(), String.format("--rollback <rollback %s>", this.getSequenceName()), this.getDocumentationLink());
                        throw new ChangeLogParseException("\n" + message);
                    }
                    if (rollbackMultiLineStartMatcher.matches()) {
                        if (rollbackMultiLineStartMatcher.groupCount() == 0) {
                            currentRollbackSequence.append((CharSequence)this.extractMultiLineRollBack(reader));
                        }
                        Scope.getCurrentScope().getLog(this.getClass()).fine("Matched alternative format rollback");
                    } else if (preconditionsMatcher.matches()) {
                        this.handlePreconditionsCase(changeSet, count, preconditionsMatcher);
                    } else {
                        if (altPreconditionsOneDashMatcher.matches()) {
                            String message = String.format(EXCEPTION_MESSAGE, physicalChangeLogLocation, count, this.getSequenceName(), "--preconditions <onFail>|<onError>|<onUpdate>", this.getDocumentationLink());
                            throw new ChangeLogParseException("\n" + message);
                        }
                        if (preconditionMatcher.matches()) {
                            this.handlePreconditionCase(changeLogParameters, changeSet, preconditionMatcher);
                        } else {
                            if (altPreconditionOneDashMatcher.matches()) {
                                String message = String.format(EXCEPTION_MESSAGE, physicalChangeLogLocation, count, this.getSequenceName(), "--precondition-sql-check", this.getDocumentationLink());
                                throw new ChangeLogParseException("\n" + message);
                            }
                            if (invalidEmptyPreconditionMatcher.matches()) {
                                this.handleInvalidEmptyPreconditionCase(changeLogParameters, changeSet, invalidEmptyPreconditionMatcher);
                            } else {
                                currentSequence.append(line).append(System.lineSeparator());
                            }
                        }
                    }
                }
            }
        }
        if (change instanceof RawSQLChange && ((RawSQLChange)change).getSqlStartLine() == null && currentSequence.length() > 1) {
            ((RawSQLChange)change).setSqlStartLine(count);
        }
        changeSetFinished.set(false);
    }

    protected ChangeSet configureChangeSet(DatabaseChangeLog changeLog, boolean runOnChange, boolean runAlways, boolean runInTransaction, boolean failOnError, String runWith, String runWithSpoolFile, String context, String labels, String logicalFilePath, String dbms, String ignore, String changeSetId, String changeSetAuthor) {
        ChangeSetService service = ChangeSetServiceFactory.getInstance().createChangeSetService();
        ChangeSet changeSet = service.createChangeSet(changeSetId, changeSetAuthor, runAlways, runOnChange, DatabaseChangeLog.normalizePath(logicalFilePath), context, dbms, runWith, runWithSpoolFile, runInTransaction, changeLog.getObjectQuotingStrategy(), changeLog);
        changeSet.setLabels(new Labels(labels));
        changeSet.setIgnore(Boolean.parseBoolean(ignore));
        changeSet.setFailOnError(failOnError);
        return changeSet;
    }

    protected void setLogicalFilePath(DatabaseChangeLog changeLog, String line, Matcher changeLogPatterMatcher) {
        if (changeLogPatterMatcher.matches()) {
            Matcher logicalFilePathMatcher = LOGICAL_FILE_PATH_PATTERN.matcher(line);
            changeLog.setLogicalFilePath(this.parseString(logicalFilePathMatcher, LOGICAL_FILE_PATH));
        }
    }

    protected String parseString(Matcher matcher, String description) {
        String matchingString = null;
        if (matcher.matches()) {
            matchingString = matcher.group(1);
            if (StringUtil.isNotEmpty(description)) {
                this.logMatch(description, matchingString, this.getClass());
            }
        }
        return matchingString;
    }

    protected InputStream openChangeLogFile(String physicalChangeLogLocation, ResourceAccessor resourceAccessor) throws IOException {
        return resourceAccessor.getExisting(physicalChangeLogLocation).openInputStream();
    }

    protected void handleInvalidEmptyPreconditionCase(ChangeLogParameters changeLogParameters, ChangeSet changeSet, Matcher preconditionMatcher) throws ChangeLogParseException {
        throw new NotImplementedException("Invalid empty precondition found");
    }

    protected static void resetSequences(StringBuilder currentSequence, StringBuilder currentRollbackSequence) {
        currentSequence.setLength(0);
        currentRollbackSequence.setLength(0);
    }

    protected boolean handleAdditionalLines(DatabaseChangeLog changeLog, ResourceAccessor resourceAccessor, String line) throws ChangeLogParseException {
        return false;
    }

    private void validateChangeSetId(String changeSetId, String line, int count) throws ChangeLogParseException {
        String parsedChangesetId = changeSetId.replace(":", "").replace(" ", "");
        if (StringUtil.isEmpty(parsedChangesetId)) {
            String message = "Unexpected formatting in formatted changelog at line %d. The change set ID cannot be empty.%n%s%nLearn all the options at https://docs.liquibase.com/concepts/changelogs/sql-format.html";
            throw new ChangeLogParseException("\n" + String.format(message, count, line));
        }
        this.logMatch(CHANGE_SET_ID, parsedChangesetId, AbstractFormattedChangeLogParser.class);
    }

    private void handleRollbackSequence(String physicalChangeLogLocation, ChangeLogParameters changeLogParameters, DatabaseChangeLog changeLog, StringBuilder currentRollbackSequence, ChangeSet changeSet, Matcher rollbackSplitStatementsPatternMatcher, boolean rollbackSplitStatements, String rollbackEndDelimiter) throws ChangeLogParseException {
        String currentRollbackSequenceAsString = currentRollbackSequence.toString();
        if (StringUtil.trimToNull(currentRollbackSequenceAsString) != null) {
            if (currentRollbackSequenceAsString.trim().toLowerCase().matches("^not required.*") || currentRollbackSequence.toString().trim().toLowerCase().matches("^empty.*")) {
                Scope.getCurrentScope().getLog(this.getClass()).fine("Matched 'not required' or 'empty' rollback attribute");
                changeSet.addRollbackChange(new EmptyChange());
            } else if (currentRollbackSequenceAsString.trim().toLowerCase().contains("changesetid")) {
                this.configureRollbackChangeSet(physicalChangeLogLocation, changeLog, changeSet, currentRollbackSequenceAsString);
            } else {
                this.configureRollbackChange(changeLogParameters, currentRollbackSequence, changeSet, rollbackSplitStatementsPatternMatcher, rollbackSplitStatements, rollbackEndDelimiter);
            }
        }
    }

    private void configureRollbackChange(ChangeLogParameters changeLogParameters, StringBuilder currentRollbackSequence, ChangeSet changeSet, Matcher rollbackSplitStatementsPatternMatcher, boolean rollbackSplitStatements, String rollbackEndDelimiter) {
        AbstractSQLChange rollbackChange = this.getChange();
        this.setChangeSequence(rollbackChange, changeLogParameters.expandExpressions(currentRollbackSequence.toString(), changeSet.getChangeLog()));
        if (rollbackSplitStatementsPatternMatcher.matches()) {
            rollbackChange.setSplitStatements(rollbackSplitStatements);
        }
        if (rollbackEndDelimiter != null) {
            rollbackChange.setEndDelimiter(rollbackEndDelimiter);
        }
        changeSet.addRollbackChange(rollbackChange);
    }

    private void configureRollbackChangeSet(String physicalChangeLogLocation, DatabaseChangeLog changeLog, ChangeSet changeSet, String currentRollBackSequenceAsString) throws ChangeLogParseException {
        String rollbackString = currentRollBackSequenceAsString.replace("\n", "").replace("\r", "");
        Matcher authorMatcher = ROLLBACK_CHANGE_SET_AUTHOR_PATTERN.matcher(rollbackString);
        Matcher idMatcher = ROLLBACK_CHANGE_SET_ID_PATTERN.matcher(rollbackString);
        Matcher pathMatcher = ROLLBACK_CHANGE_SET_PATH_PATTERN.matcher(rollbackString);
        String changeSetAuthor = StringUtil.trimToNull(this.parseString(authorMatcher, AUTHOR));
        String changeSetId = StringUtil.trimToNull(this.parseString(idMatcher, ID));
        String changeSetPath = StringUtil.trimToNull(this.parseString(pathMatcher, CHANGE_SET_PATH));
        if (changeSetId == null) {
            throw new ChangeLogParseException("'changesetId' not set in rollback block '" + rollbackString + "'");
        }
        if (changeSetAuthor == null) {
            throw new ChangeLogParseException("'changesetAuthor' not set in rollback block '" + rollbackString + "'");
        }
        if (changeSetPath == null) {
            changeSetPath = physicalChangeLogLocation;
        }
        ChangeSet rollbackChangeSet = changeLog.getChangeSet(changeSetPath, changeSetAuthor, changeSetId);
        DatabaseChangeLog parent = changeLog;
        while (rollbackChangeSet == null && parent != null) {
            if ((parent = parent.getParentChangeLog()) == null) continue;
            rollbackChangeSet = parent.getChangeSet(changeSetPath, changeSetAuthor, changeSetId);
        }
        if (rollbackChangeSet == null) {
            throw new ChangeLogParseException("Change set " + new ChangeSet(changeSetId, changeSetAuthor, false, false, changeSetPath, null, null, null).toString(false) + " does not exist");
        }
        for (Change rollbackChange : rollbackChangeSet.getChanges()) {
            changeSet.addRollbackChange(rollbackChange);
        }
    }

    private void handleProperty(ChangeLogParameters changeLogParameters, DatabaseChangeLog changeLog, String line) {
        String dbms;
        String labels;
        String context;
        String value;
        Matcher namePatternMatcher = NAME_PATTERN.matcher(line);
        Matcher valuePatternMatcher = VALUE_PATTERN.matcher(line);
        Matcher contextPatternMatcher = CONTEXT_PATTERN.matcher(line);
        Matcher contextFilterPatternMatcher = CONTEXT_FILTER_PATTERN.matcher(line);
        Matcher labelsPatternMatcher = LABELS_PATTERN.matcher(line);
        Matcher dbmsPatternMatcher = DBMS_PATTERN.matcher(line);
        Matcher globalPatternMatcher = GLOBAL_PATTERN.matcher(line);
        String name = this.parseString(namePatternMatcher, PROPERTY_NAME);
        if (name != null) {
            name = changeLogParameters.expandExpressions(name, changeLog);
        }
        if ((value = this.parseString(valuePatternMatcher, PROPERTY_VALUE)) != null) {
            value = changeLogParameters.expandExpressions(value, changeLog);
        }
        if ((context = this.parseString(contextFilterPatternMatcher, PROPERTY_CONTEXT_FILTER)) == null || context.isEmpty()) {
            context = this.parseString(contextPatternMatcher, PROPERTY_CONTEXT);
        }
        if (context != null) {
            context = changeLogParameters.expandExpressions(StringUtil.stripEnclosingQuotes(context), changeLog);
        }
        if ((labels = this.parseString(labelsPatternMatcher, LABELS)) != null) {
            labels = changeLogParameters.expandExpressions(StringUtil.stripEnclosingQuotes(labels), changeLog);
        }
        if ((dbms = this.parseString(dbmsPatternMatcher, DBMS)) != null) {
            dbms = changeLogParameters.expandExpressions(dbms.trim(), changeLog);
        }
        boolean global = this.parseBoolean(globalPatternMatcher);
        changeLogParameters.set(name, (Object)value, context, labels, dbms, global, changeLog);
    }

    private StringBuilder extractMultiLineRollBack(BufferedReader reader) throws IOException, ChangeLogParseException {
        StringBuilder multiLineRollback = new StringBuilder();
        if (reader != null) {
            String line;
            while ((line = reader.readLine()) != null) {
                if (this.ROLLBACK_MULTI_LINE_END_PATTERN.matcher(line).matches()) {
                    String[] lastLineSplit = line.split(String.format("%s\\s*$", this.getEndMultiLineCommentSequence()));
                    if (lastLineSplit.length > 0 && !StringUtil.isWhitespace(lastLineSplit[0])) {
                        multiLineRollback.append(lastLineSplit[0]);
                    }
                    return multiLineRollback;
                }
                multiLineRollback.append(line);
            }
            throw new ChangeLogParseException("Liquibase rollback comment is not closed.");
        }
        return multiLineRollback;
    }

    private boolean parseBoolean(Matcher matcher) {
        boolean value = true;
        if (matcher.matches()) {
            value = Boolean.parseBoolean(matcher.group(1));
        }
        return value;
    }

    protected boolean parseBoolean(Matcher matcher, ChangeSet changeSet, boolean defaultValue) throws ChangeLogParseException {
        return this.parseBoolean(matcher, changeSet, defaultValue, null);
    }

    protected boolean parseBoolean(Matcher matcher, ChangeSet changeSet, boolean defaultValue, String description) throws ChangeLogParseException {
        boolean booleanMatch = defaultValue;
        if (matcher.matches()) {
            try {
                booleanMatch = Boolean.parseBoolean(matcher.group(1));
                this.logMatch(description, String.valueOf(booleanMatch), this.getClass());
            }
            catch (Exception e) {
                throw new ChangeLogParseException("Cannot parse " + changeSet + " " + matcher.toString().replaceAll("\\.*", "") + " as a boolean", e);
            }
        }
        return booleanMatch;
    }

    protected void logMatch(String attribute, String value, Class<? extends AbstractFormattedChangeLogParser> clazz) {
        if (StringUtil.isEmpty(attribute)) {
            return;
        }
        Scope.getCurrentScope().getLog(clazz).fine("Matched attribute '" + attribute + "' = '" + value + "'");
    }
}

