/*
 * Decompiled with CFR 0.152.
 */
package liquibase.hub;

import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.logging.Level;
import liquibase.Contexts;
import liquibase.LabelExpression;
import liquibase.RuntimeEnvironment;
import liquibase.Scope;
import liquibase.changelog.ChangeLogIterator;
import liquibase.changelog.ChangeSet;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.changelog.visitor.ListVisitor;
import liquibase.changelog.visitor.RollbackListVisitor;
import liquibase.command.CommandFactory;
import liquibase.command.CommandResult;
import liquibase.command.core.SyncHubCommand;
import liquibase.database.Database;
import liquibase.exception.DatabaseException;
import liquibase.exception.LiquibaseException;
import liquibase.hub.HubService;
import liquibase.hub.HubServiceFactory;
import liquibase.hub.LiquibaseHubException;
import liquibase.hub.model.Connection;
import liquibase.hub.model.HubChangeLog;
import liquibase.hub.model.Operation;
import liquibase.hub.model.OperationChange;
import liquibase.hub.model.OperationEvent;
import liquibase.logging.core.BufferedLogService;

public class HubUpdater {
    private final Date startTime;
    private final DatabaseChangeLog changeLog;

    public HubUpdater(Date startTime, DatabaseChangeLog changeLog) {
        this.startTime = startTime;
        this.changeLog = changeLog;
    }

    public Operation preUpdateHub(String operationType, Database database, Connection connection, String changeLogFile, Contexts contexts, LabelExpression labelExpression, ChangeLogIterator changeLogIterator) throws LiquibaseHubException, DatabaseException, LiquibaseException {
        if (this.hubIsNotAvailable(this.changeLog.getChangeLogId())) {
            return null;
        }
        this.syncHub(changeLogFile, database, this.changeLog, connection.getId());
        HubService hubService = Scope.getCurrentScope().getSingleton(HubServiceFactory.class).getService();
        HubChangeLog hubChangeLog = hubService.getHubChangeLog(UUID.fromString(this.changeLog.getChangeLogId()));
        Operation updateOperation = hubService.createOperation(operationType, hubChangeLog, connection);
        try {
            hubService.sendOperationEvent(updateOperation, new OperationEvent().setEventType("START").setStartDate(this.startTime).setOperationEventStatus(new OperationEvent.OperationEventStatus().setOperationEventStatusType("PASS").setStatusMessage("Update operation started successfully")));
        }
        catch (LiquibaseException e2) {
            Scope.getCurrentScope().getLog(this.getClass()).warning(e2.getMessage(), e2);
        }
        ListVisitor listVisitor = operationType.toUpperCase().equals("ROLLBACK") ? new RollbackListVisitor() : new ListVisitor();
        changeLogIterator.run(listVisitor, new RuntimeEnvironment(database, contexts, labelExpression));
        List<ChangeSet> operationChangeSets = listVisitor.getSeenChangeSets();
        OperationChange operationChange = new OperationChange();
        for (ChangeSet operationChangeSet : operationChangeSets) {
            operationChange.getChangeSets().add(operationChangeSet);
        }
        operationChange.setProject(hubChangeLog.getProject());
        operationChange.setOperation(updateOperation);
        try {
            hubService.sendOperationChanges(operationChange);
        }
        catch (LiquibaseException e3) {
            Scope.getCurrentScope().getLog(this.getClass()).warning(e3.getMessage(), e3);
        }
        return updateOperation;
    }

    public void postUpdateHub(Operation updateOperation, BufferedLogService bufferLog) {
        try {
            if (updateOperation == null || this.hubIsNotAvailable(this.changeLog.getChangeLogId())) {
                return;
            }
            HubService hubService = Scope.getCurrentScope().getSingleton(HubServiceFactory.class).getService();
            hubService.sendOperationEvent(updateOperation, new OperationEvent().setEventType("COMPLETE").setStartDate(this.startTime).setEndDate(new Date()).setOperationEventStatus(new OperationEvent.OperationEventStatus().setOperationEventStatusType("PASS").setStatusMessage("Update operation completed successfully")).setOperationEventLog(new OperationEvent.OperationEventLog().setLogMessage(bufferLog.getLogAsString(Level.INFO)).setTimestampLog(this.startTime)));
        }
        catch (LiquibaseException e2) {
            Scope.getCurrentScope().getLog(this.getClass()).warning(e2.getMessage(), e2);
        }
    }

    public void postUpdateHubExceptionHandling(Operation updateOperation, BufferedLogService bufferLog, String originalExceptionMessage) {
        try {
            if (updateOperation == null || this.hubIsNotAvailable(this.changeLog.getChangeLogId())) {
                return;
            }
            HubService hubService = Scope.getCurrentScope().getSingleton(HubServiceFactory.class).getService();
            hubService.sendOperationEvent(updateOperation, new OperationEvent().setEventType("COMPLETE").setStartDate(this.startTime).setEndDate(new Date()).setOperationEventStatus(new OperationEvent.OperationEventStatus().setOperationEventStatusType("FAIL").setStatusMessage("Update operation completed with errors")).setOperationEventLog(new OperationEvent.OperationEventLog().setLogMessage(bufferLog.getLogAsString(Level.INFO))));
        }
        catch (LiquibaseException serviceException) {
            Scope.getCurrentScope().getLog(this.getClass()).warning(originalExceptionMessage, serviceException);
        }
    }

    public boolean hubIsNotAvailable(String changeLogId) {
        HubService hubService = Scope.getCurrentScope().getSingleton(HubServiceFactory.class).getService();
        return !hubService.isOnline() || changeLogId == null;
    }

    public void syncHub(String changeLogFile, Database database, DatabaseChangeLog databaseChangeLog, UUID hubConnectionId) {
        SyncHubCommand syncHub = (SyncHubCommand)CommandFactory.getInstance().getCommand("syncHub");
        syncHub.setChangeLogFile(changeLogFile);
        syncHub.setUrl(database.getConnection().getURL());
        syncHub.setHubConnectionId(hubConnectionId != null ? Objects.toString(hubConnectionId) : null);
        syncHub.setDatabase(database);
        syncHub.setFailIfOnline(false);
        try {
            syncHub.configure(Collections.singletonMap("changeLog", databaseChangeLog));
            Object commandResult = syncHub.execute();
            if (!((CommandResult)commandResult).succeeded) {
                Scope.getCurrentScope().getLog(this.getClass()).warning("Liquibase Hub sync failed: " + ((CommandResult)commandResult).message);
            }
        }
        catch (Exception e2) {
            Scope.getCurrentScope().getLog(this.getClass()).warning("Liquibase Hub sync failed: " + e2.getMessage(), e2);
        }
    }
}

