/*
 * Decompiled with CFR 0.152.
 */
package liquibase.snapshot.jvm;

import java.util.HashMap;
import java.util.List;
import liquibase.database.AbstractJdbcDatabase;
import liquibase.database.Database;
import liquibase.database.core.DB2Database;
import liquibase.database.core.DerbyDatabase;
import liquibase.database.core.InformixDatabase;
import liquibase.diff.compare.DatabaseObjectComparatorFactory;
import liquibase.exception.DatabaseException;
import liquibase.snapshot.CachedRow;
import liquibase.snapshot.DatabaseSnapshot;
import liquibase.snapshot.InvalidExampleException;
import liquibase.snapshot.JdbcDatabaseSnapshot;
import liquibase.snapshot.jvm.JdbcSnapshotGenerator;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Column;
import liquibase.structure.core.ForeignKey;
import liquibase.structure.core.Index;
import liquibase.structure.core.Schema;
import liquibase.structure.core.Table;
import liquibase.structure.core.UniqueConstraint;
import liquibase.util.StringUtils;

public class IndexSnapshotGenerator
extends JdbcSnapshotGenerator {
    public IndexSnapshotGenerator() {
        super(Index.class, new Class[]{Table.class, ForeignKey.class, UniqueConstraint.class});
    }

    @Override
    protected void addTo(DatabaseObject foundObject, DatabaseSnapshot snapshot) throws DatabaseException, InvalidExampleException {
        if (!snapshot.getSnapshotControl().shouldInclude(Index.class)) {
            return;
        }
        if (foundObject instanceof Table) {
            Table table = (Table)foundObject;
            Database database = snapshot.getDatabase();
            Schema schema = table.getSchema();
            List<CachedRow> rs = null;
            JdbcDatabaseSnapshot.CachingDatabaseMetaData databaseMetaData = null;
            try {
                databaseMetaData = ((JdbcDatabaseSnapshot)snapshot).getMetaData();
                rs = databaseMetaData.getIndexInfo(((AbstractJdbcDatabase)database).getJdbcCatalogName(schema), ((AbstractJdbcDatabase)database).getJdbcSchemaName(schema), table.getName(), null);
                HashMap<String, Index> foundIndexes = new HashMap<String, Index>();
                for (CachedRow row : rs) {
                    String indexName = row.getString("INDEX_NAME");
                    if (indexName == null) continue;
                    Index index = (Index)foundIndexes.get(indexName);
                    if (index == null) {
                        index = new Index();
                        index.setName(indexName);
                        index.setTable(table);
                        foundIndexes.put(indexName, index);
                    }
                    index.getColumns().add(row.getString("COLUMN_NAME"));
                }
                for (Index exampleIndex : foundIndexes.values()) {
                    table.getIndexes().add(exampleIndex);
                }
            }
            catch (Exception e) {
                throw new DatabaseException(e);
            }
        }
        if (foundObject instanceof UniqueConstraint && !(snapshot.getDatabase() instanceof DB2Database) && !(snapshot.getDatabase() instanceof DerbyDatabase)) {
            Index exampleIndex = new Index().setTable(((UniqueConstraint)foundObject).getTable()).setName(foundObject.getName());
            exampleIndex.getColumns().addAll(((UniqueConstraint)foundObject).getColumns());
            ((UniqueConstraint)foundObject).setBackingIndex(exampleIndex);
        }
    }

    @Override
    protected DatabaseObject snapshotObject(DatabaseObject example, DatabaseSnapshot snapshot) throws DatabaseException, InvalidExampleException {
        Database database = snapshot.getDatabase();
        Table exampleTable = ((Index)example).getTable();
        String tableName = null;
        Schema schema = null;
        if (exampleTable != null) {
            tableName = exampleTable.getName();
            schema = exampleTable.getSchema();
        }
        if (schema == null) {
            schema = new Schema(database.getDefaultCatalogName(), database.getDefaultSchemaName());
        }
        for (int i = 0; i < ((Index)example).getColumns().size(); ++i) {
            ((Index)example).getColumns().set(i, database.correctObjectName(((Index)example).getColumns().get(i), Column.class));
        }
        String exampleName = example.getName();
        if (exampleName != null) {
            exampleName = database.correctObjectName(exampleName, Index.class);
        }
        HashMap<String, Index> foundIndexes = new HashMap<String, Index>();
        JdbcDatabaseSnapshot.CachingDatabaseMetaData databaseMetaData = null;
        List<CachedRow> rs = null;
        try {
            databaseMetaData = ((JdbcDatabaseSnapshot)snapshot).getMetaData();
            rs = databaseMetaData.getIndexInfo(((AbstractJdbcDatabase)database).getJdbcCatalogName(schema), ((AbstractJdbcDatabase)database).getJdbcSchemaName(schema), tableName, exampleName);
            for (CachedRow row : rs) {
                String filterCondition;
                String indexName = database.correctObjectName(this.cleanNameFromDatabase(row.getString("INDEX_NAME"), database), Index.class);
                if (indexName == null || (!database.isCaseSensitive() ? exampleName != null && !exampleName.equalsIgnoreCase(indexName) : exampleName != null && !exampleName.equals(indexName))) continue;
                if (database instanceof InformixDatabase && indexName.startsWith(" ")) {
                    indexName = "_generated_index_" + indexName.substring(1);
                }
                short type = row.getShort("TYPE");
                Boolean nonUnique = row.getBoolean("NON_UNIQUE");
                if (nonUnique == null) {
                    nonUnique = true;
                }
                String columnName = this.cleanNameFromDatabase(row.getString("COLUMN_NAME"), database);
                short position = row.getShort("ORDINAL_POSITION");
                if (database instanceof InformixDatabase && type != 0 && position == 0) {
                    position = (short)(position + 1);
                    System.out.println(this.getClass().getName() + ": corrected position to " + position);
                }
                if ((filterCondition = StringUtils.trimToNull(row.getString("FILTER_CONDITION"))) != null) {
                    columnName = filterCondition = filterCondition.replaceAll("\"", "");
                }
                if (type == 0 || columnName == null) continue;
                Index returnIndex = (Index)foundIndexes.get(indexName);
                if (returnIndex == null) {
                    returnIndex = new Index();
                    returnIndex.setTable((Table)new Table().setName(row.getString("TABLE_NAME")).setSchema(schema));
                    returnIndex.setName(indexName);
                    returnIndex.setUnique(nonUnique == false);
                    foundIndexes.put(indexName, returnIndex);
                }
                for (int i = returnIndex.getColumns().size(); i < position; ++i) {
                    returnIndex.getColumns().add(null);
                }
                returnIndex.getColumns().set(position - 1, columnName);
            }
        }
        catch (Exception e) {
            throw new DatabaseException(e);
        }
        if (exampleName != null) {
            return (DatabaseObject)foundIndexes.get(exampleName);
        }
        for (Index index : foundIndexes.values()) {
            if (!DatabaseObjectComparatorFactory.getInstance().isSameObject(index.getTable(), exampleTable, database) || !(database.isCaseSensitive() ? index.getColumnNames().equals(((Index)example).getColumnNames()) : index.getColumnNames().equalsIgnoreCase(((Index)example).getColumnNames()))) continue;
            return index;
        }
        return null;
    }
}

