/*
 * Decompiled with CFR 0.152.
 */
package liquibase.parser.core.yaml;

import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import liquibase.ContextExpression;
import liquibase.changelog.ChangeLogParameters;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.exception.ChangeLogParseException;
import liquibase.logging.LogFactory;
import liquibase.logging.Logger;
import liquibase.parser.ChangeLogParser;
import liquibase.parser.core.ParsedNode;
import liquibase.resource.ResourceAccessor;
import liquibase.util.StreamUtil;
import org.yaml.snakeyaml.Yaml;

public class YamlChangeLogParser
implements ChangeLogParser {
    protected Logger log = LogFactory.getLogger();

    @Override
    public boolean supports(String changeLogFile, ResourceAccessor resourceAccessor) {
        for (String extension : this.getSupportedFileExtensions()) {
            if (!changeLogFile.toLowerCase().endsWith("." + extension)) continue;
            return true;
        }
        return false;
    }

    protected String[] getSupportedFileExtensions() {
        return new String[]{"yaml", "yml"};
    }

    @Override
    public int getPriority() {
        return 1;
    }

    @Override
    public DatabaseChangeLog parse(String physicalChangeLogLocation, ChangeLogParameters changeLogParameters, ResourceAccessor resourceAccessor) throws ChangeLogParseException {
        Yaml yaml = new Yaml();
        try {
            Map parsedYaml;
            InputStream changeLogStream = StreamUtil.singleInputStream(physicalChangeLogLocation, resourceAccessor);
            if (changeLogStream == null) {
                throw new ChangeLogParseException(physicalChangeLogLocation + " does not exist");
            }
            try {
                parsedYaml = (Map)yaml.loadAs(changeLogStream, Map.class);
            }
            catch (Exception e) {
                throw new ChangeLogParseException("Syntax error in " + this.getSupportedFileExtensions()[0] + ": " + e.getMessage(), e);
            }
            List rootList = (List)parsedYaml.get("databaseChangeLog");
            if (rootList == null) {
                throw new ChangeLogParseException("Could not find databaseChangeLog node");
            }
            for (Object obj : rootList) {
                if (!(obj instanceof Map) || !((Map)obj).containsKey("property")) continue;
                Map property = (Map)((Map)obj).get("property");
                ContextExpression context = new ContextExpression((String)property.get("context"));
                if (property.containsKey("name")) {
                    Object value = property.get("value");
                    if (value != null) {
                        value = value.toString();
                    }
                    changeLogParameters.set((String)property.get("name"), (String)value, context, (String)property.get("dbms"));
                    continue;
                }
                if (!property.containsKey("file")) continue;
                Properties props = new Properties();
                InputStream propertiesStream = StreamUtil.singleInputStream((String)property.get("file"), resourceAccessor);
                if (propertiesStream == null) {
                    this.log.info("Could not open properties file " + property.get("file"));
                    continue;
                }
                props.load(propertiesStream);
                for (Map.Entry<Object, Object> entry : props.entrySet()) {
                    changeLogParameters.set(entry.getKey().toString(), entry.getValue().toString(), context, (String)property.get("dbms"));
                }
            }
            this.replaceParameters(parsedYaml, changeLogParameters);
            DatabaseChangeLog changeLog = new DatabaseChangeLog(physicalChangeLogLocation);
            changeLog.setChangeLogParameters(changeLogParameters);
            ParsedNode databaseChangeLogNode = new ParsedNode(null, "databaseChangeLog");
            databaseChangeLogNode.setValue(rootList);
            changeLog.load(databaseChangeLogNode, resourceAccessor);
            return changeLog;
        }
        catch (Throwable e) {
            if (e instanceof ChangeLogParseException) {
                throw (ChangeLogParseException)e;
            }
            throw new ChangeLogParseException(e);
        }
    }

    protected void replaceParameters(Object obj, ChangeLogParameters changeLogParameters) {
        block5: {
            block4: {
                if (!(obj instanceof Map)) break block4;
                for (Map.Entry entry : ((Map)obj).entrySet()) {
                    if (entry.getValue() instanceof Map || entry.getValue() instanceof Collection) {
                        this.replaceParameters(entry.getValue(), changeLogParameters);
                        continue;
                    }
                    if (!(entry.getValue() instanceof String)) continue;
                    entry.setValue(changeLogParameters.expandExpressions((String)entry.getValue()));
                }
                break block5;
            }
            if (!(obj instanceof Collection)) break block5;
            ListIterator<String> iterator = ((List)obj).listIterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (e instanceof Map || e instanceof Collection) {
                    this.replaceParameters(e, changeLogParameters);
                    continue;
                }
                if (!(e instanceof String)) continue;
                iterator.set(changeLogParameters.expandExpressions((String)e));
            }
        }
    }
}

