/*
 * Decompiled with CFR 0.152.
 */
package liquibase.changelog.filter;

import java.util.List;
import liquibase.changelog.ChangeSet;
import liquibase.changelog.RanChangeSet;
import liquibase.changelog.filter.ChangeSetFilter;
import liquibase.changelog.filter.ChangeSetFilterResult;
import liquibase.database.Database;
import liquibase.exception.DatabaseException;

public class ShouldRunChangeSetFilter
implements ChangeSetFilter {
    private final List<RanChangeSet> ranChangeSets;
    private final boolean ignoreClasspathPrefix;

    public ShouldRunChangeSetFilter(Database database, boolean ignoreClasspathPrefix) throws DatabaseException {
        this.ignoreClasspathPrefix = ignoreClasspathPrefix;
        this.ranChangeSets = database.getRanChangeSetList();
    }

    public ShouldRunChangeSetFilter(Database database) throws DatabaseException {
        this(database, true);
    }

    @Override
    public ChangeSetFilterResult accepts(ChangeSet changeSet) {
        for (RanChangeSet ranChangeSet : this.ranChangeSets) {
            if (!this.changeSetsMatch(changeSet, ranChangeSet)) continue;
            if (changeSet.shouldAlwaysRun()) {
                return new ChangeSetFilterResult(true, "Change set always runs", this.getClass());
            }
            if (changeSet.shouldRunOnChange() && this.checksumChanged(changeSet, ranChangeSet)) {
                return new ChangeSetFilterResult(true, "Change set checksum changed", this.getClass());
            }
            return new ChangeSetFilterResult(false, "Change set already ran", this.getClass());
        }
        return new ChangeSetFilterResult(true, "Change set has not ran yet", this.getClass());
    }

    protected boolean changeSetsMatch(ChangeSet changeSet, RanChangeSet ranChangeSet) {
        return this.idsAreEqual(changeSet, ranChangeSet) && this.authorsAreEqual(changeSet, ranChangeSet) && this.pathsAreEqual(changeSet, ranChangeSet);
    }

    protected boolean idsAreEqual(ChangeSet changeSet, RanChangeSet ranChangeSet) {
        return ranChangeSet.getId().equals(changeSet.getId());
    }

    protected boolean authorsAreEqual(ChangeSet changeSet, RanChangeSet ranChangeSet) {
        return ranChangeSet.getAuthor().equals(changeSet.getAuthor());
    }

    private boolean pathsAreEqual(ChangeSet changeSet, RanChangeSet ranChangeSet) {
        return this.getPath(ranChangeSet).equalsIgnoreCase(this.getPath(changeSet));
    }

    protected boolean checksumChanged(ChangeSet changeSet, RanChangeSet ranChangeSet) {
        return !changeSet.generateCheckSum().equals(ranChangeSet.getLastCheckSum());
    }

    private String getPath(RanChangeSet ranChangeSet) {
        return this.normalizePath(ranChangeSet.getChangeLog());
    }

    private String getPath(ChangeSet changeSet) {
        return this.normalizePath(changeSet.getFilePath());
    }

    protected String normalizePath(String filePath) {
        if (this.ignoreClasspathPrefix) {
            return filePath.replaceFirst("^classpath:", "");
        }
        return filePath;
    }
}

