/*
 * Decompiled with CFR 0.152.
 */
package liquibase.datatype.core;

import liquibase.database.Database;
import liquibase.database.core.DB2Database;
import liquibase.database.core.DerbyDatabase;
import liquibase.database.core.FirebirdDatabase;
import liquibase.database.core.HsqlDatabase;
import liquibase.database.core.InformixDatabase;
import liquibase.database.core.MSSQLDatabase;
import liquibase.database.core.MySQLDatabase;
import liquibase.database.core.OracleDatabase;
import liquibase.database.core.SQLiteDatabase;
import liquibase.database.core.SybaseASADatabase;
import liquibase.database.core.SybaseDatabase;
import liquibase.datatype.DataTypeInfo;
import liquibase.datatype.DatabaseDataType;
import liquibase.datatype.LiquibaseDataType;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.statement.DatabaseFunction;

@DataTypeInfo(name="boolean", aliases={"java.sql.Types.BOOLEAN", "java.lang.Boolean", "bit"}, minParameters=0, maxParameters=0, priority=1)
public class BooleanType
extends LiquibaseDataType {
    @Override
    public DatabaseDataType toDatabaseDataType(Database database) {
        if (database instanceof DB2Database || database instanceof FirebirdDatabase) {
            return new DatabaseDataType("SMALLINT");
        }
        if (database instanceof MSSQLDatabase) {
            return new DatabaseDataType("BIT");
        }
        if (database instanceof MySQLDatabase) {
            if (this.getRawDefinition().toLowerCase().startsWith("bit")) {
                return new DatabaseDataType("BIT", this.getParameters());
            }
            return new DatabaseDataType("BIT", 1);
        }
        if (database instanceof OracleDatabase) {
            return new DatabaseDataType("NUMBER", 1);
        }
        if (database instanceof SybaseASADatabase || database instanceof SybaseDatabase) {
            return new DatabaseDataType("BIT");
        }
        if (database instanceof DerbyDatabase) {
            if (((DerbyDatabase)database).supportsBooleanDataType()) {
                return new DatabaseDataType("BOOLEAN");
            }
            return new DatabaseDataType("SMALLINT");
        }
        if (database instanceof HsqlDatabase) {
            return new DatabaseDataType("BOOLEAN");
        }
        return super.toDatabaseDataType(database);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String objectToSql(Object value, Database database) {
        if (value == null) return null;
        if (value.toString().equalsIgnoreCase("null")) {
            return null;
        }
        if (value instanceof String) {
            if (((String)value).equalsIgnoreCase("true")) return this.getTrueBooleanValue(database);
            if (value.equals("1")) return this.getTrueBooleanValue(database);
            if (value.equals("t")) return this.getTrueBooleanValue(database);
            if (((String)value).equalsIgnoreCase(this.getTrueBooleanValue(database))) {
                return this.getTrueBooleanValue(database);
            }
            if (((String)value).equalsIgnoreCase("false")) return this.getFalseBooleanValue(database);
            if (value.equals("0")) return this.getFalseBooleanValue(database);
            if (value.equals("f")) return this.getFalseBooleanValue(database);
            if (!((String)value).equalsIgnoreCase(this.getFalseBooleanValue(database))) throw new UnexpectedLiquibaseException("Unknown boolean value: " + value);
            return this.getFalseBooleanValue(database);
        }
        if (value instanceof Long) {
            if (!Long.valueOf(1L).equals(value)) return this.getFalseBooleanValue(database);
            return this.getTrueBooleanValue(database);
        }
        if (value instanceof Number) {
            if (!value.equals(1)) return this.getFalseBooleanValue(database);
            return this.getTrueBooleanValue(database);
        }
        if (value instanceof DatabaseFunction) {
            return value.toString();
        }
        if (!(value instanceof Boolean)) throw new UnexpectedLiquibaseException("Cannot convert type " + value.getClass() + " to a boolean value");
        if ((Boolean)value == false) return this.getFalseBooleanValue(database);
        return this.getTrueBooleanValue(database);
    }

    protected boolean isNumericBoolean(Database database) {
        if (database instanceof DerbyDatabase) {
            return !((DerbyDatabase)database).supportsBooleanDataType();
        }
        return database instanceof DB2Database || database instanceof FirebirdDatabase || database instanceof MSSQLDatabase || database instanceof MySQLDatabase || database instanceof OracleDatabase || database instanceof SQLiteDatabase || database instanceof SybaseASADatabase || database instanceof SybaseDatabase;
    }

    public String getFalseBooleanValue(Database database) {
        if (this.isNumericBoolean(database)) {
            return "0";
        }
        if (database instanceof InformixDatabase) {
            return "'f'";
        }
        return "FALSE";
    }

    public String getTrueBooleanValue(Database database) {
        if (this.isNumericBoolean(database)) {
            return "1";
        }
        if (database instanceof InformixDatabase) {
            return "'t'";
        }
        return "TRUE";
    }
}

