/*
 * Decompiled with CFR 0.152.
 */
package liquibase.parser.core.yaml;

import java.io.File;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import liquibase.Contexts;
import liquibase.change.AddColumnConfig;
import liquibase.change.Change;
import liquibase.change.ChangeFactory;
import liquibase.change.ChangeParameterMetaData;
import liquibase.change.ColumnConfig;
import liquibase.change.ConstraintsConfig;
import liquibase.change.core.AddColumnChange;
import liquibase.change.core.CreateIndexChange;
import liquibase.changelog.ChangeLogParameters;
import liquibase.changelog.ChangeSet;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.exception.ChangeLogParseException;
import liquibase.exception.LiquibaseException;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.logging.LogFactory;
import liquibase.logging.Logger;
import liquibase.parser.ChangeLogParser;
import liquibase.parser.ChangeLogParserFactory;
import liquibase.precondition.CustomPreconditionWrapper;
import liquibase.precondition.Precondition;
import liquibase.precondition.PreconditionFactory;
import liquibase.precondition.PreconditionLogic;
import liquibase.precondition.core.PreconditionContainer;
import liquibase.resource.ResourceAccessor;
import liquibase.sql.visitor.SqlVisitor;
import liquibase.sql.visitor.SqlVisitorFactory;
import liquibase.statement.DatabaseFunction;
import liquibase.statement.SequenceCurrentValueFunction;
import liquibase.statement.SequenceNextValueFunction;
import liquibase.util.ObjectUtil;
import liquibase.util.file.FilenameUtils;
import org.yaml.snakeyaml.Yaml;

public class YamlChangeLogParser
implements ChangeLogParser {
    protected Logger log = LogFactory.getLogger();

    @Override
    public boolean supports(String changeLogFile, ResourceAccessor resourceAccessor) {
        return changeLogFile.endsWith("." + this.getSupportedFileExtension());
    }

    protected String getSupportedFileExtension() {
        return "yaml";
    }

    @Override
    public int getPriority() {
        return 1;
    }

    @Override
    public DatabaseChangeLog parse(String physicalChangeLogLocation, ChangeLogParameters changeLogParameters, ResourceAccessor resourceAccessor) throws ChangeLogParseException {
        Yaml yaml = new Yaml();
        try {
            InputStream changeLogStream = resourceAccessor.getResourceAsStream(physicalChangeLogLocation);
            if (changeLogStream == null) {
                throw new ChangeLogParseException("Change log file " + physicalChangeLogLocation + " does not exist");
            }
            Map changeLogAsMap = null;
            try {
                changeLogAsMap = (Map)yaml.loadAs(changeLogStream, Map.class);
            }
            catch (Exception e) {
                throw new ChangeLogParseException("Syntax error in " + this.getSupportedFileExtension() + ": " + e.getMessage(), e);
            }
            DatabaseChangeLog changeLog = new DatabaseChangeLog(physicalChangeLogLocation);
            changeLog.setChangeLogParameters(changeLogParameters);
            List rootList = (List)changeLogAsMap.get("databaseChangeLog");
            if (rootList == null) {
                throw new ChangeLogParseException("Could not find root databaseChangeLog node");
            }
            for (Map nestedMap : rootList) {
                String objectType = (String)nestedMap.keySet().iterator().next();
                if (objectType.equals("changeSet")) {
                    Map changeSetMap = (Map)nestedMap.get("changeSet");
                    if (changeSetMap == null) {
                        throw new ChangeLogParseException("Null changeSet map");
                    }
                    this.checkRequiredAttribute("changeSet", "id", changeSetMap);
                    this.checkRequiredAttribute("changeSet", "author", changeSetMap);
                    ChangeSet changeSet = new ChangeSet(this.getValue(changeSetMap, "id", String.class, changeLogParameters), this.getValue(changeSetMap, "author", String.class, changeLogParameters), this.getValue(changeSetMap, "alwaysRun", Boolean.TYPE, false, changeLogParameters), this.getValue(changeSetMap, "runOnChange", Boolean.TYPE, false, changeLogParameters), physicalChangeLogLocation, this.getValue(changeSetMap, "context", String.class, changeLogParameters), this.getValue(changeSetMap, "dbms", String.class, changeLogParameters), changeLog);
                    try {
                        List validCheckSums;
                        List changes = null;
                        try {
                            changes = this.getValue(changeSetMap, "changes", List.class, changeLogParameters);
                        }
                        catch (ClassCastException e) {
                            throw new ChangeLogParseException("Invalid 'changes' format in " + changeSet.toString(false));
                        }
                        if (changes != null) {
                            for (Map changeMap : changes) {
                                Change change = this.parseChange(changeMap, changeLogParameters, resourceAccessor, changeSet);
                                changeSet.addChange(change);
                            }
                        }
                        List preconditions = null;
                        try {
                            preconditions = this.getValue(changeSetMap, "preConditions", List.class, changeLogParameters);
                        }
                        catch (ClassCastException e) {
                            throw new ChangeLogParseException("Invalid 'preConditions' format in " + changeSet.toString(false));
                        }
                        if (preconditions != null) {
                            changeSet.setPreconditions(new PreconditionContainer());
                            for (Map preconditionMap : preconditions) {
                                String preconditionName = (String)preconditionMap.keySet().iterator().next();
                                if (preconditionName.equals("onFail")) {
                                    changeSet.getPreconditions().setOnFail(this.getValue(preconditionMap, "onFail", String.class, null, changeLogParameters));
                                    continue;
                                }
                                if (preconditionName.equals("onFailMessage")) {
                                    changeSet.getPreconditions().setOnFailMessage(this.getValue(preconditionMap, "onFailMessage", String.class, null, changeLogParameters));
                                    continue;
                                }
                                if (preconditionName.equals("onError")) {
                                    changeSet.getPreconditions().setOnError(this.getValue(preconditionMap, "onError", String.class, null, changeLogParameters));
                                    continue;
                                }
                                if (preconditionName.equals("onErrorMessage")) {
                                    changeSet.getPreconditions().setOnErrorMessage(this.getValue(preconditionMap, "onErrorMessage", String.class, null, changeLogParameters));
                                    continue;
                                }
                                Precondition precondition = this.parsePrecondition(preconditionMap);
                                changeSet.getPreconditions().addNestedPrecondition(precondition);
                            }
                        }
                        if ((validCheckSums = this.getValue(changeSetMap, "validCheckSums", List.class, changeLogParameters)) != null) {
                            for (String string : validCheckSums) {
                                changeSet.addValidCheckSum(string);
                            }
                        }
                        List sqlVisitors = null;
                        try {
                            sqlVisitors = this.getValue(changeSetMap, "modifySql", List.class, changeLogParameters);
                        }
                        catch (ClassCastException e) {
                            throw new ChangeLogParseException("Invalid 'modifySql' format in " + changeSet.toString(false));
                        }
                        if (sqlVisitors != null) {
                            for (Map visitor : sqlVisitors) {
                                if (visitor.size() != 1) {
                                    throw new ChangeLogParseException("Invalid modifySql syntax");
                                }
                                String visitorName = (String)visitor.keySet().iterator().next();
                                SqlVisitor sqlVisitor = SqlVisitorFactory.getInstance().create(visitorName);
                                Map visitorParams = (Map)visitor.get(visitorName);
                                for (String param : visitorParams.keySet()) {
                                    Object value;
                                    if (param.equals("dbms")) {
                                        value = this.getValue(visitorParams, param, String.class, changeLogParameters);
                                        String dbms = ((String)value).toString().replace(" ", "");
                                        sqlVisitor.setApplicableDbms(new HashSet<String>(Arrays.asList(dbms.split(","))));
                                        continue;
                                    }
                                    if (param.equals("context")) {
                                        value = this.getValue(visitorParams, param, String.class, changeLogParameters);
                                        String context = ((String)value).toString().replace(" ", "");
                                        sqlVisitor.setContexts(new Contexts(context.split(",")));
                                        continue;
                                    }
                                    if (param.equals("applyToRollback")) {
                                        value = this.getValue(visitorParams, param, Boolean.class, changeLogParameters);
                                        sqlVisitor.setApplyToRollback((Boolean)value);
                                        continue;
                                    }
                                    value = this.getValue(visitorParams, param, Object.class, changeLogParameters);
                                    if (value != null) {
                                        value = value.toString();
                                    }
                                    ObjectUtil.setProperty(sqlVisitor, param, (String)value);
                                }
                                changeSet.addSqlVisitor(sqlVisitor);
                            }
                        }
                        List rollbackChanges = null;
                        try {
                            rollbackChanges = this.getValue(changeSetMap, "rollback", List.class, changeLogParameters);
                        }
                        catch (ClassCastException e) {
                            throw new ChangeLogParseException("Invalid 'rollback' format in " + changeSet.toString(false));
                        }
                        if (rollbackChanges != null) {
                            for (Map changeMap : rollbackChanges) {
                                Change change = this.parseChange(changeMap, changeLogParameters, resourceAccessor, changeSet);
                                change.setChangeSet(changeSet);
                                changeSet.addRollbackChange(change);
                            }
                        }
                        changeLog.addChangeSet(changeSet);
                        continue;
                    }
                    catch (Throwable e) {
                        throw new ChangeLogParseException(e + " in " + changeSet.toString(false), e);
                    }
                }
                if (objectType.equals("property")) {
                    Map propertyMap = (Map)nestedMap.get("property");
                    String name = this.getValue(propertyMap, "name", String.class, changeLogParameters);
                    Object value = this.getValue(propertyMap, "value", Object.class, changeLogParameters);
                    String file = this.getValue(propertyMap, "file", String.class, changeLogParameters);
                    String context = this.getValue(propertyMap, "context", String.class, changeLogParameters);
                    String dbms = this.getValue(propertyMap, "dbms", String.class, changeLogParameters);
                    if (name != null) {
                        if (value == null) {
                            throw new ChangeLogParseException("No value for property " + name);
                        }
                        changeLog.getChangeLogParameters().set(name, value.toString(), context, dbms);
                        continue;
                    }
                    if (file == null) continue;
                    Properties props = new Properties();
                    InputStream propertiesStream = resourceAccessor.getResourceAsStream(file);
                    if (propertiesStream == null) {
                        this.log.info("Could not open properties file " + file);
                        continue;
                    }
                    props.load(propertiesStream);
                    for (Map.Entry<Object, Object> entry : props.entrySet()) {
                        changeLog.getChangeLogParameters().set(entry.getKey().toString(), entry.getValue().toString(), context, dbms);
                    }
                    continue;
                }
                if (objectType.equals("preConditions")) {
                    List preconditions = (List)nestedMap.get("preConditions");
                    if (preconditions == null) {
                        throw new ChangeLogParseException("Null preConditions map");
                    }
                    PreconditionContainer rootPrecondition = new PreconditionContainer();
                    for (Map preconditionContainerMap : preconditions) {
                        Map preconditionMap;
                        String preconditionName = (String)preconditionContainerMap.keySet().iterator().next();
                        if (preconditionName.equals("onFail")) {
                            rootPrecondition.setOnFail(this.getValue(preconditionContainerMap, "onFail", String.class, null, changeLogParameters));
                            continue;
                        }
                        if (preconditionName.equals("onError")) {
                            rootPrecondition.setOnError(this.getValue(preconditionContainerMap, "onError", String.class, null, changeLogParameters));
                            continue;
                        }
                        if (preconditionName.equals("onFailMessage")) {
                            rootPrecondition.setOnFailMessage(this.getValue(preconditionContainerMap, "onFailMessage", String.class, null, changeLogParameters));
                            continue;
                        }
                        if (preconditionName.equals("onErrorMessage")) {
                            rootPrecondition.setOnErrorMessage(this.getValue(preconditionContainerMap, "onErrorMessage", String.class, null, changeLogParameters));
                            continue;
                        }
                        preconditionMap = (Map)preconditionContainerMap.get(preconditionName);
                        Precondition precondition = PreconditionFactory.getInstance().create(preconditionName);
                        try {
                            for (Map.Entry param : preconditionMap.entrySet()) {
                                ObjectUtil.setProperty(precondition, (String)param.getKey(), param.getValue().toString());
                            }
                        }
                        catch (Throwable e) {
                            throw new ChangeLogParseException(e);
                        }
                        rootPrecondition.addNestedPrecondition(precondition);
                    }
                    changeLog.setPreconditions(rootPrecondition);
                    continue;
                }
                if (objectType.equals("include")) {
                    Map includeMap = (Map)nestedMap.get("include");
                    String file = this.getValue(includeMap, "file", String.class, changeLogParameters);
                    if (file == null) {
                        throw new ChangeLogParseException("Missing include 'file' attribute");
                    }
                    file = file.replace('\\', '/');
                    boolean isRelativeToChangelogFile = this.getValue(includeMap, "relativeToChangelogFile", Boolean.class, false, changeLogParameters);
                    this.handleIncludedChangeLog(file, isRelativeToChangelogFile, physicalChangeLogLocation, changeLog, changeLogParameters, resourceAccessor);
                    continue;
                }
                if (objectType.equals("includeAll")) {
                    throw new ChangeLogParseException("includeAll not yet supported in " + this.getSupportedFileExtension());
                }
                throw new ChangeLogParseException("Unexpected databaseChangeLog node: " + objectType);
            }
            return changeLog;
        }
        catch (Throwable e) {
            throw new ChangeLogParseException(e);
        }
    }

    public Change parseChange(Map<String, Object> changeMap, ChangeLogParameters changeLogParameters, ResourceAccessor resourceAccessor, ChangeSet changeSet) throws ChangeLogParseException {
        String changeName = changeMap.keySet().iterator().next();
        Change change = ChangeFactory.getInstance().create(changeName);
        change.setResourceAccessor(resourceAccessor);
        if (changeMap.size() != 1) {
            throw new ChangeLogParseException("Invalid format for changeSet " + changeSet.toString(false));
        }
        for (Map.Entry param : ((Map)changeMap.get(changeName)).entrySet()) {
            ChangeParameterMetaData changeParameterMetaData = ChangeFactory.getInstance().getChangeMetaData(change).getParameters().get(param.getKey());
            if (changeParameterMetaData == null) {
                throw new ChangeLogParseException("Unexpected parameter " + (String)param.getKey() + " for " + changeName);
            }
            Object value = param.getValue();
            String dataType = changeParameterMetaData.getDataType();
            if (dataType.equals("list of columnConfig") || dataType.equals("list of addColumnConfig")) {
                ArrayList<ColumnConfig> columnList = new ArrayList<ColumnConfig>();
                for (Map columnMap : (List)value) {
                    Map constraintsMap;
                    String defaultValueSequenceNext;
                    String valueSequenceNext;
                    String valueSequenceCurrent;
                    if (columnMap.size() != 1) {
                        throw new ChangeLogParseException("Invalid 'column' syntax");
                    }
                    Map column = (Map)columnMap.get("column");
                    ColumnConfig columnConfig = change instanceof CreateIndexChange || change instanceof AddColumnChange ? new AddColumnConfig() : new ColumnConfig();
                    columnConfig.setName(this.getValue(column, "name", String.class, changeLogParameters));
                    columnConfig.setType(this.getValue(column, "type", String.class, changeLogParameters));
                    columnConfig.setAutoIncrement(this.getValue(column, "autoIncrement", Boolean.class, changeLogParameters));
                    columnConfig.setIncrementBy(this.getValue(column, "incrementBy", BigInteger.class, changeLogParameters));
                    columnConfig.setRemarks(this.getValue(column, "remarks", String.class, changeLogParameters));
                    columnConfig.setStartWith(this.getValue(column, "startWith", BigInteger.class, changeLogParameters));
                    columnConfig.setValue(this.getValue(column, "value", String.class, changeLogParameters));
                    columnConfig.setValueNumeric(this.getValue(column, "valueNumeric", String.class, changeLogParameters));
                    columnConfig.setValueBlobFile(this.getValue(column, "valueBlobFile", String.class, changeLogParameters));
                    columnConfig.setValueBoolean(this.getValue(column, "valueBoolean", String.class, changeLogParameters));
                    columnConfig.setValueClobFile(this.getValue(column, "valueClob", String.class, changeLogParameters));
                    columnConfig.setValueDate(this.getValue(column, "valueDate", String.class, changeLogParameters));
                    String valueComputed = this.getValue(column, "valueComputed", String.class, changeLogParameters);
                    if (valueComputed != null) {
                        columnConfig.setValueComputed(new DatabaseFunction(valueComputed));
                    }
                    if ((valueSequenceCurrent = this.getValue(column, "valueSequenceCurrent", String.class, changeLogParameters)) != null) {
                        columnConfig.setValueSequenceCurrent(new SequenceCurrentValueFunction(valueSequenceCurrent));
                    }
                    if ((valueSequenceNext = this.getValue(column, "valueSequenceNext", String.class, changeLogParameters)) != null) {
                        columnConfig.setValueSequenceNext(new SequenceNextValueFunction(valueSequenceNext));
                    }
                    columnConfig.setDefaultValueNumeric(this.getValue(column, "defaultValueNumeric", Number.class, changeLogParameters));
                    columnConfig.setDefaultValueBoolean(this.getValue(column, "defaultValueBoolean", Boolean.class, changeLogParameters));
                    columnConfig.setDefaultValueDate(this.getValue(column, "defaultValueDate", String.class, changeLogParameters));
                    String defaultValueComputed = this.getValue(column, "defaultValueComputed", String.class, changeLogParameters);
                    if (defaultValueComputed != null) {
                        columnConfig.setDefaultValueComputed(new DatabaseFunction(defaultValueComputed));
                    }
                    if ((defaultValueSequenceNext = this.getValue(column, "defaultValueSequenceNext", String.class, changeLogParameters)) != null) {
                        columnConfig.setDefaultValueSequenceNext(new SequenceNextValueFunction(defaultValueSequenceNext));
                    }
                    if ((constraintsMap = (Map)column.get("constraints")) != null) {
                        ConstraintsConfig constraints = new ConstraintsConfig();
                        constraints.setCheckConstraint(this.getValue(constraintsMap, "checkConstraint", String.class, changeLogParameters));
                        constraints.setDeferrable(this.getValue(constraintsMap, "deferrable", Boolean.class, changeLogParameters));
                        constraints.setInitiallyDeferred(this.getValue(constraintsMap, "initiallyDeferred", Boolean.class, changeLogParameters));
                        constraints.setDeleteCascade(this.getValue(constraintsMap, "deleteCascade", String.class, changeLogParameters));
                        constraints.setForeignKeyName(this.getValue(constraintsMap, "foreignKeyName", String.class, changeLogParameters));
                        constraints.setReferencedColumnNames(this.getValue(constraintsMap, "referencedColumnNames", String.class, changeLogParameters));
                        constraints.setReferencedTableName(this.getValue(constraintsMap, "referencedTableName", String.class, changeLogParameters));
                        constraints.setReferences(this.getValue(constraintsMap, "references", String.class, changeLogParameters));
                        constraints.setNullable(this.getValue(constraintsMap, "nullable", Boolean.class, changeLogParameters));
                        constraints.setPrimaryKey(this.getValue(constraintsMap, "primaryKey", String.class, changeLogParameters));
                        constraints.setPrimaryKeyTablespace(this.getValue(constraintsMap, "primaryKeyTablespace", String.class, changeLogParameters));
                        constraints.setPrimaryKeyName(this.getValue(constraintsMap, "primaryKeyName", String.class, changeLogParameters));
                        constraints.setUnique(this.getValue(constraintsMap, "unique", Boolean.class, changeLogParameters));
                        constraints.setUniqueConstraintName(this.getValue(constraintsMap, "uniqueConstraintName", String.class, changeLogParameters));
                        columnConfig.setConstraints(constraints);
                    }
                    columnList.add(columnConfig);
                }
                value = columnList;
            }
            changeParameterMetaData.setValue(change, value);
        }
        return change;
    }

    private Precondition parsePrecondition(Map<String, Object> preconditionMap) throws ChangeLogParseException {
        Precondition precondition;
        block7: {
            String preconditionName = preconditionMap.keySet().iterator().next();
            precondition = PreconditionFactory.getInstance().create(preconditionName);
            try {
                Object children = preconditionMap.get(preconditionName);
                if (children instanceof Map) {
                    for (Map.Entry param : ((Map)children).entrySet()) {
                        if (precondition instanceof CustomPreconditionWrapper && ((String)param.getKey()).equals("params")) {
                            List params = (List)param.getValue();
                            for (Map paramMap : params) {
                                paramMap = (Map)paramMap.get("param");
                                ((CustomPreconditionWrapper)precondition).setParam(paramMap.get("name").toString(), paramMap.get("value").toString());
                            }
                            continue;
                        }
                        ObjectUtil.setProperty(precondition, (String)param.getKey(), param.getValue().toString());
                    }
                    break block7;
                }
                for (Map child : (Collection)children) {
                    ((PreconditionLogic)precondition).addNestedPrecondition(this.parsePrecondition(child));
                }
            }
            catch (Throwable e) {
                throw new ChangeLogParseException("Error parsing precondition '" + preconditionName + "'", e);
            }
        }
        return precondition;
    }

    private <T> T getValue(Map<String, Object> map, String key, Class<T> type, T defaultValue, ChangeLogParameters changeLogParameters) {
        if (map.containsKey(key)) {
            Object mapValue = map.get(key);
            if (mapValue == null) {
                return null;
            }
            if (mapValue != null && mapValue instanceof String && ((String)mapValue).startsWith("${")) {
                mapValue = changeLogParameters.expandExpressions((String)mapValue);
            }
            if (type.isAssignableFrom(mapValue.getClass())) {
                return (T)mapValue;
            }
            if (type.equals(String.class)) {
                return (T)mapValue.toString();
            }
            if (type.equals(Boolean.TYPE) && mapValue.getClass().equals(Boolean.class)) {
                return (T)mapValue;
            }
            throw new UnexpectedLiquibaseException("Could not convert " + mapValue.getClass().getName() + " '" + mapValue + "' to " + type.getName());
        }
        return defaultValue;
    }

    private <T> T getValue(Map<String, Object> map, String key, Class<T> type, ChangeLogParameters changeLogParameters) {
        return this.getValue(map, key, type, null, changeLogParameters);
    }

    private void checkRequiredAttribute(String outerNode, String key, Map map) throws ChangeLogParseException {
        if (!map.containsKey(key)) {
            throw new ChangeLogParseException(outerNode + " is missing required attribute " + key);
        }
    }

    protected boolean handleIncludedChangeLog(String fileName, boolean isRelativePath, String relativeBaseFileName, DatabaseChangeLog databaseChangeLog, ChangeLogParameters changeLogParameters, ResourceAccessor resourceAccessor) throws LiquibaseException {
        DatabaseChangeLog changeLog;
        PreconditionContainer preconditions;
        if (fileName.equalsIgnoreCase(".svn") || fileName.equalsIgnoreCase("cvs")) {
            return false;
        }
        ChangeLogParser changeLogParser = ChangeLogParserFactory.getInstance().getParser(fileName, resourceAccessor);
        if (changeLogParser == null) {
            this.log.warning("included file " + relativeBaseFileName + "/" + fileName + " is not a recognized file type");
            return false;
        }
        if (isRelativePath) {
            String tempFile = FilenameUtils.concat(FilenameUtils.getFullPath(relativeBaseFileName), fileName);
            fileName = tempFile != null && new File(tempFile).exists() ? tempFile : FilenameUtils.getFullPath(relativeBaseFileName) + fileName;
        }
        if ((preconditions = (changeLog = ChangeLogParserFactory.getInstance().getParser(fileName, resourceAccessor).parse(fileName, changeLogParameters, resourceAccessor)).getPreconditions()) != null) {
            if (null == databaseChangeLog.getPreconditions()) {
                databaseChangeLog.setPreconditions(new PreconditionContainer());
            }
            databaseChangeLog.getPreconditions().addNestedPrecondition(preconditions);
        }
        for (ChangeSet changeSet : changeLog.getChangeSets()) {
            databaseChangeLog.addChangeSet(changeSet);
        }
        return true;
    }
}

