/*
 * Decompiled with CFR 0.152.
 */
package org.kubek2k.mockito.spring.factory;

import java.lang.reflect.Method;
import org.mockito.Mockito;
import org.mockito.cglib.proxy.MethodInterceptor;
import org.mockito.cglib.proxy.MethodProxy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThreadLocalMockMethodInterceptor<T>
implements MethodInterceptor {
    private InheritableThreadLocal<T> mockLocalForCurrentThread;
    private Class<T> mockClass;

    public ThreadLocalMockMethodInterceptor(Class<T> mockClass) {
        this.mockClass = mockClass;
        this.mockLocalForCurrentThread = new InheritableThreadLocal();
    }

    private T getOrCreateMockForCurrentThread() {
        Object threadLocalInstance = this.mockLocalForCurrentThread.get();
        if (threadLocalInstance == null) {
            threadLocalInstance = this.createMock();
            this.mockLocalForCurrentThread.set(threadLocalInstance);
        }
        return threadLocalInstance;
    }

    public Object intercept(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable {
        return method.invoke(this.getOrCreateMockForCurrentThread(), args);
    }

    private T createMock() {
        return (T)Mockito.mock(this.mockClass);
    }
}

