package org.kth.dks.util;

/**
 * Implements a Future that is reset after it returns an object with get()
 * <p>Title: DKS</p>
 * <p>Description: DKS Middleware</p>
 * <p>Copyright: Copyright (c) 2004</p>
 * <p>Company: KTH-IMIT/SICS</p>
 * @author not attributable
 * @version 1.0
 */

public class ReusableFuture extends Future{

  /**
   * Same functionality as Future.get() but in addition resets its flags such that
   * it can be reused as if it was a new Future
   * @throws InterruptedException
   * @throws CancellationException
   * @return Object
   * @see Future
   */
  public synchronized Object get() throws InterruptedException, CancellationException, Exception {
      Object res = super.get();
      this.completed = false;
      this.cancelled = false;
      return res;
    }

    /**
     * Same functionality as Future.get() but in addition resets its flags such that
     * it can be reused as if it was a new Future
     * @param timeout long
     * @throws TimeoutException
     * @throws InterruptedException
     * @throws CancellationException
     * @return Object
     * @see Future
     */
    public synchronized Object get(long timeout)
        throws TimeoutException, InterruptedException, CancellationException {
      Object res = super.get(timeout);
      this.completed = false;
      this.cancelled = false;
      return res;
    }
}
