package org.kth.dks.util;

public class AtomicBoolean {
	private boolean value;
	
	public AtomicBoolean() {
		this(false);
	}

	public AtomicBoolean(boolean initValue) {
		value = initValue;
	}

	public final synchronized boolean get() {
		return value;
	}
	
	public final synchronized boolean compareAndSet(boolean expect, boolean update) {
		if (value==expect) {
			value=update;
			return true;
		}
		return false;
	}
	
	public final synchronized void set(boolean newValue) {
		value = newValue;
	}
	
	public final synchronized boolean getAndSet(boolean newValue) {
		boolean old = value;
		value = newValue;
		return old;
	}
	
	public String toString() {
		return ""+value;
	}
}
