package org.kth.dks.planetlab.messages;

import java.io.IOException;

import org.kth.dks.dks_comm.DKSRef;
import org.kth.dks.dks_marshal.DKSMessage;

public class StrechMeasurementMsg extends DKSMessage {
	public static String NAME = "STRECH_MEASUREMENT";

	private String fromHostname;

	private DKSRef fromDKSRef;

	private long fromIp;

	private long toIp;

	private int dksRttMs;

	private int ipRttMs;

	public StrechMeasurementMsg() {
	}

	public StrechMeasurementMsg(String fromHostname, DKSRef fromDKSRef,
			long fromIp, long toIp, int dksRttMs, int ipRttMs) {
		super();
		this.fromHostname = fromHostname;
		this.fromDKSRef = fromDKSRef;
		this.fromIp = fromIp;
		this.toIp = toIp;
		this.dksRttMs = dksRttMs;
		this.ipRttMs = ipRttMs;
	}

	public String getFromHostname() {
		return fromHostname;
	}

	public void setFromHostname(String fromHostname) {
		this.fromHostname = fromHostname;
	}

	public DKSRef getFromDKSRef() {
		return fromDKSRef;
	}

	public void setFromDKSRef(DKSRef fomDKSRef) {
		this.fromDKSRef = fomDKSRef;
	}

	public int getDksRttMs() {
		return dksRttMs;
	}

	public void setDksRttMs(int dksRttMs) {
		this.dksRttMs = dksRttMs;
	}

	public long getFromIp() {
		return fromIp;
	}

	public void setFromIp(long fromIp) {
		this.fromIp = fromIp;
	}

	public int getIpRttMs() {
		return ipRttMs;
	}

	public void setIpRttMs(int ipRttMs) {
		this.ipRttMs = ipRttMs;
	}

	public long getToIp() {
		return toIp;
	}

	public void setToIp(long toIp) {
		this.toIp = toIp;
	}

	public String getName() {
		return NAME;
	}

	public void marshal() throws IOException {
		marshaler.addString(fromHostname, "fromHostname");
		marshaler.addDKSRef(fromDKSRef, "fromDKSRef");
		marshaler.addLong(fromIp, "fromIp");
		marshaler.addLong(toIp, "toIp");
		marshaler.addInt(dksRttMs, "dksRttMs");
		marshaler.addInt(ipRttMs, "ipRttMs");
	}

	public void unmarshal() throws IOException {
		fromHostname = marshaler.remString("fromHostname");
		fromDKSRef = marshaler.remDKSRef("fromDKSRef");
		fromIp = marshaler.remLong("fromIp");
		toIp = marshaler.remLong("toIp");
		dksRttMs = marshaler.remInt("dksRttMs");
		ipRttMs = marshaler.remInt("ipRttMs");
	}
}
