package org.kth.dks.planetlab.messages;

import java.io.IOException;
import java.util.ArrayList;

import org.kth.dks.dks_comm.DKSRef;
import org.kth.dks.dks_marshal.DKSMessage;

public class LiveNodesMsg extends DKSMessage {
	public enum Type {REQUEST, REPLY, CHOICE};
	
	public static String NAME = "LIVE_NODES";

	private Type type; 
	
	private int size;
	
	private ArrayList<DKSRef> refs;

	public LiveNodesMsg() {
	}

	public LiveNodesMsg(Type type, int size, ArrayList<DKSRef> refs) {
		this.type = type;
		this.size = size;
		this.refs = refs;
	}

	public String getName() {
		return NAME;
	}

	public int getSize() {
		return size;
	}

	public Type getType() {
		return type;
	}

	public ArrayList<DKSRef> getRefs() {
		return refs;
	}

	public void marshal() throws IOException {
		marshaler.addInt(type.ordinal(), "type");
		marshaler.addInt(size, "size");
		if (refs == null) return;
		
		for (int i = 0; i < refs.size(); i++) {
			marshaler.addDKSRef(refs.get(i), "ref" + i);
		}
	}

	public void unmarshal() throws IOException {
		int ord = marshaler.remInt("type");
		type = ord == 0 ? Type.REQUEST : (ord == 1 ? Type.REPLY : Type.CHOICE);
		size = marshaler.remInt("size");
		refs = new ArrayList<DKSRef>();
		for (int i = 0; i < refs.size(); i++) {
			refs.add(marshaler.remDKSRef("ref" + i));
		}
	}
}
