package org.kth.dks.dks_node;

/**
 * <p>Title: DKS</p>
 * <p>Description: DKS Middleware</p>
 * <p>Copyright: Copyright (c) 2004</p>
 * <p>Company: KTH-IMIT</p>
 * @author not attributable
 * @version 1.0
 */


public class LookupType {
  private final String value;

  public static final LookupType INSERT      = new LookupType("insert");
  public static final LookupType REMOVE      = new LookupType("remove");
  public static final LookupType ADDRESS     = new LookupType("address");
  public static final LookupType JOINADDRESS = new LookupType("joinaddress");
  public static final LookupType SYNCDATA    = new LookupType("syncdata");
  public static final LookupType ASYNCDATA   = new LookupType("asyncdata");

  public String toString() { return value; }

  /**
   * Converts the String into a InsertType, useful when unmarshalling strings
   * @param insertTypeString is a string, e.g. "insert"
   * @return InsertType is the right instance of insertTypeString
   */
  static public LookupType valueOf(String lookupTypeString) {
    if (lookupTypeString.equalsIgnoreCase(INSERT.toString()))
      return INSERT;
    else if (lookupTypeString.equalsIgnoreCase(REMOVE.toString()))
      return REMOVE;
    else if (lookupTypeString.equalsIgnoreCase(ADDRESS.toString()))
      return ADDRESS;
    else if (lookupTypeString.equalsIgnoreCase(ASYNCDATA.toString()))
      return ASYNCDATA;
    else if (lookupTypeString.equalsIgnoreCase(JOINADDRESS.toString()))
      return JOINADDRESS;
    else if (lookupTypeString.equalsIgnoreCase(SYNCDATA.toString()))
      return SYNCDATA;
    return null;
  }

  private LookupType (String val) { value=val; }
}
