package org.kth.dks.dks_node;

import org.kth.dks.DKSObject;
import org.kth.dks.util.AsyncOperation;
import org.kth.dks.util.CancellationException;

public class DKSLookup {

  static public DKSObject[] lookup(DKSNode dksNode, long key) {
    DKSObject[] dksObjects = null;
    AsyncOperation op = AsyncOperation.start();
    dksNode.search(key, null, op.getKey());

    try { dksObjects = (DKSObject[]) op.waitOn(); }
    catch (CancellationException e) { }
    catch (InterruptedException e) { }
    catch (Exception e) { };

    if (dksObjects == null) return new DKSObject[0];
    else return dksObjects;
  }

  static public void putResult(String opName, DKSObject[] result) {
      AsyncOperation op = AsyncOperation.get(opName);
      if (op != null) op.complete(result);
  }
}
