package org.kth.dks.dks_marshal;

import java.io.IOException;
import java.util.List;

import org.kth.dks.DKSObject;
import org.kth.dks.dks_comm.DKSNetAddress;
import org.kth.dks.dks_comm.DKSRef;

/**
 * <p>Title: DKS</p>
 *
 * <p>Description: DKS Middleware</p>
 *
 * <p>Copyright: Copyright (c) 2005</p>
 *
 * <p>Company: KTH-IMIT/SICS</p>
 *
 * @author Ali Ghodsi (aligh@kth.se)
 * @version 1.0
 */

public abstract class MarshalInterface {

  protected final DKSMessage msg;

  public MarshalInterface(DKSMessage m) {
    msg = m;
  }

  public MarshalInterface() { msg = null; }

  public abstract byte[] flatten();

//  public abstract void unflatten(XMLMessage xml);

  public abstract void addLong(long val) throws IOException;
  public abstract void addLong(long val, String na) throws IOException;

  public abstract void addInt(int val) throws IOException;
  public abstract void addInt(int val, String na) throws IOException;

  public abstract void addString(String val) throws IOException;
  public abstract void addString(String val, String na) throws IOException;

  public abstract void addBool(boolean val) throws IOException;
  public abstract void addBool(boolean val, String na) throws IOException;

  public abstract void addDKSObject(DKSObject val) throws IOException;
  public abstract void addDKSObject(DKSObject val, String na) throws IOException;

  public abstract void addDKSRef(DKSRef val) throws IOException;
  public abstract void addDKSRef(DKSRef val, String na) throws IOException;

  public abstract void addDKSNetAddress(DKSNetAddress val) throws IOException;
  public abstract void addDKSNetAddress(DKSNetAddress val, String na) throws IOException;

  public abstract void addDKSRefArray(DKSRef[] val) throws IOException;
  public abstract void addDKSRefArray(DKSRef[] val, String na) throws IOException;

  public abstract void addByteArray(byte[] m) throws IOException;
  public abstract void addByteArray(byte[] m, String na) throws IOException;

  // ######################## REMOVE OPERATIONS ##########################

  public abstract String remString() throws IOException;
  public abstract String remString(String na) throws IOException;

  public abstract long remLong() throws IOException;
  public abstract long remLong(String na) throws IOException;

  public abstract int remInt() throws IOException;
  public abstract int remInt(String na) throws IOException;

  public abstract boolean remBool() throws IOException;
  public abstract boolean remBool(String na) throws IOException;

  public abstract DKSObject remDKSObject() throws IOException;
  public abstract DKSObject remDKSObject(String na) throws IOException;

  public abstract DKSRef remDKSRef() throws IOException;
  public abstract DKSRef remDKSRef(String na) throws IOException;

  public abstract DKSNetAddress remDKSNetAddress() throws IOException;
  public abstract DKSNetAddress remDKSNetAddress(String na) throws IOException;

  public abstract List remDKSRefArray() throws IOException;
  public abstract List remDKSRefArray(String na) throws IOException;

  public abstract byte[] remByteArray() throws IOException;
  public abstract byte[] remByteArray(String na) throws IOException;

}
