package org.kth.dks.dks_marshal;

/**
 * <p>Title: DKS</p>
 * <p>Description: DKS Middleware</p>
 * <p>Copyright: Copyright (c) 2005</p>
 * <p>Company: KTH-IMIT</p>
 * @author Ali Ghodsi (aligh@kth.se)
 * @version 1.0
 */

import java.io.IOException;

public class LookupFailureMsg
    extends DKSMessage { // shouldnt be public!
  private static String NAME = "LOOKUPFAILURE";
  private long target;
  private String msgId;

  public String getName() {
    return NAME;
  }

  public long getTarget() {
    return target;
  }

  public String getMsgId() {
    return msgId;
  }

  public LookupFailureMsg() {

  }

  public LookupFailureMsg(long target, String msgId) {

    this.target = target;
    this.msgId = msgId;
  }

  public void marshal() throws IOException {
    marshaler.addLong(target, "targetid");

    marshaler.addBool(msgId == null ? false : true , "anyinsertid");

    if (msgId != null) {
      marshaler.addString(msgId, "insertid");
    }

  }

  public void unmarshal() throws IOException {
    target = marshaler.remLong("targetid");

    final boolean anyId = marshaler.remBool("anyinsertid");
    if (anyId) {
      msgId = marshaler.remString("insertid");
    }
  }
}
