package org.kth.dks.dks_marshal;

/**
 * <p>Title: DKS</p>
 * <p>Description: DKS Middleware</p>
 * <p>Copyright: Copyright (c) 2005</p>
 * <p>Company: KTH-IMIT</p>
 * @author Ali Ghodsi (aligh@kth.se)
 * @version 1.0
 */

import java.io.IOException;

import org.kth.dks.dks_comm.DKSRef;

public class LeaveRequestMsg extends DKSMessage {
  private static String NAME= "LEAVEREQUEST";
  private DKSRef p;

  public LeaveRequestMsg() {
  }

  public LeaveRequestMsg( DKSRef p ) {
    this.p = p;
  }

  public String getName() { return NAME; }
  public DKSRef getP() { return p; }

  public void marshal() throws IOException {
    marshaler.addDKSRef(p, "pred");

  }

  public void unmarshal() throws IOException {
    p = marshaler.remDKSRef("pred");
  }
}
