package org.kth.dks.dks_marshal;

/**
 * <p>Title: DKS</p>
 * <p>Description: DKS Middleware</p>
 * <p>Copyright: Copyright (c) 2005</p>
 * <p>Company: KTH-IMIT</p>
 * @author Ali Ghodsi (aligh@kth.se)
 * @version 1.0
 */

import java.io.IOException;

import org.kth.dks.dks_comm.DKSRef;
import org.kth.dks.dks_node.Interval;

public class CorrectionOnJoinMsg extends DKSMessage implements CorrectionOnChangeInterface { // shouldnt be public!
  private static String NAME= "CORRECTIONONJOIN";
  private DKSRef newNode;
  private Interval interval;

  public String getName() { return NAME; }
  public DKSRef getNewNode() { return newNode; }
  public Interval getInterval() { return interval; }

  public CorrectionOnJoinMsg() {
  }

  public CorrectionOnJoinMsg(DKSRef newNode, Interval i) {
    this.newNode = newNode;
    this.interval = i;
  }

  public void marshal() throws IOException {
    marshaler.addDKSRef(newNode, "newnode");
    marshaler.addLong(interval.start, "intervalstart");
    marshaler.addLong(interval.end, "intervalend");

  }

  public void unmarshal() throws IOException {
    newNode = marshaler.remDKSRef("newnode");
    long s  = marshaler.remLong("intervalstart");
    long e  = marshaler.remLong("intervalend");
    interval = new Interval(s, e);
  }

}
