package org.kth.dks.dks_marshal;

/**
 * <p>Title: DKS</p>
 * <p>Description: DKS Middleware</p>
 * <p>Copyright: Copyright (c) 2005</p>
 * <p>Company: KTH-IMIT</p>
 * @author Ali Ghodsi (aligh@kth.se)
 * @version 1.0
 */

import java.io.IOException;

import org.kth.dks.DKSObject;

public class BroadCastMsg extends DKSMessage{
    private static String NAME= "BROADCAST";

    private long limit;
    private long start;
    private DKSObject payload;
    private boolean internal = false; // default is false
    private boolean leaf = false;

    public String getName() { return NAME; }
    public long getLimit() { return limit; }
    public long getStart() { return start; }
    public boolean getInternal() { return internal; }

    public DKSObject getPayload(){
	return payload;
    }

  public BroadCastMsg() {

  }

  /**
   * Warning! No defensive copying done for performance reasons!
   * @param start start of the broadcast interval
   * @param limit end of the broadcast interval
   */
    public BroadCastMsg(long start,  long limit, DKSObject pl){

      this.start   = start;
      this.limit   = limit;
      this.payload = pl;
    }

    /**
     * Warning! No defensive copying done for performance reasons!
     * @param start start of the broadcast interval
     * @param limit end of the broadcast interval
     */
    public BroadCastMsg(long start,  long limit, DKSObject pl, boolean internal) {

      this.start   = start;
      this.limit   = limit;
      this.payload = pl;
      this.internal = internal;
    }


  public void marshal() throws IOException {
    marshaler.addLong(limit, "limit");
    marshaler.addLong(start, "start");
    marshaler.addString(payload.toString(), "payload");
    marshaler.addBool(internal, "internal");

  }

  public void unmarshal() throws IOException {
    limit    = marshaler.remLong("limit");
    start    = marshaler.remLong("start");
    payload  = new DKSObject( marshaler.remString("payload") );
    internal = marshaler.remBool("internal");
  }
}
