package org.kth.dks.dks_marshal;

/**
 * <p>Title: DKS</p>
 * <p>Description: DKS Middleware</p>
 * <p>Copyright: Copyright (c) 2005</p>
 * <p>Company: KTH-IMIT</p>
 * @author Ali Ghodsi (aligh@kth.se)
 * @version 1.0
 */

import java.io.IOException;

import org.kth.dks.dks_comm.DKSRef;

public class BecomeNormalMsg extends DKSMessage {
  private static String NAME = "BECOMENORMAL";
  private DKSRef p;

  public String getName() {
    return NAME;
  }

  public DKSRef getP() {
    return p;
  }

  public BecomeNormalMsg() {

  }

  public BecomeNormalMsg(DKSRef p) {

    this.p = p;
  }

  public void marshal() throws IOException {
    marshaler.addDKSRef(p, "dksref");

  }

  public void unmarshal() throws IOException {
    p = marshaler.remDKSRef("dksref");
  }
}
