package org.kth.dks.dks_marshal;

/**
 * <p>Title: DKS</p>
 * <p>Description: DKS Middleware</p>
 * <p>Copyright: Copyright (c) 2005</p>
 * <p>Company: KTH-IMIT</p>
 * @author Ali Ghodsi (aligh@kth.se)
 * @version 1.0
 */

import java.io.IOException;
import java.util.List;

import org.kth.dks.dks_comm.DKSRef;

public class AckHelloMsg extends DKSMessage {
  private static String NAME= "ACKHELLO";
  private DKSRef [] dArray;

  public String getName() { return NAME; }
   public DKSRef [] getDKSRefs() { return dArray; }

  public AckHelloMsg() {

  }

  public AckHelloMsg( DKSRef [] d ) {
    this.dArray = d;
  }

  public void marshal() throws IOException {
    marshaler.addDKSRefArray(dArray, "stackref");

  }

  public void unmarshal() throws IOException {
    List l = marshaler.remDKSRefArray("stackref");
    dArray = (DKSRef [])l.toArray(new DKSRef[0]);
  }
}
