package org.kth.dks.dks_exceptions;

import java.net.MalformedURLException;

import org.apache.log4j.Logger;
import org.kth.dks.dks_comm.DKSNetAddress;

public class DKSRefNoResponse extends Exception {
  private Logger log = Logger.getLogger(DKSRefNoResponse.class);
  private DKSNetAddress ref = null;
  public DKSRefNoResponse(DKSNetAddress r) {
    try {
      ref = new DKSNetAddress(r.getDKSNetURL());
    } catch (MalformedURLException ex) {
      log.error(
                       "Could not make a deep copy of the DKSRef:"+
                       r.getDKSNetURL()+"\n"+ex);
    }
  }

  public String toString() {
    return "org.kth.dks.dks_exceptions.DKSRefNoResponse" +
        ( ref==null? "" : "(destination: "+ref.getDKSNetURL()+")" );
  }

}
