package org.kth.dks.dks_dht;

import java.io.IOException;

import org.kth.dks.DKSObject;
import org.kth.dks.dks_marshal.DKSMessage;

public class RemoveItemMsg extends DKSMessage {
  public final static String NAME = "REMOVEITEMMSG";
  public DKSObject payload = null;
  public long key;
    public int index;
  public String getName() {
    return NAME;
  }

  public RemoveItemMsg() {
  }

  public RemoveItemMsg(long id, int i, DKSObject pld) {
    key = id;
    payload = pld;
    index = i ;
  }

  public DKSObject getPayLoad() { return payload; }

  public long getMsgId() { return key; }

  public void marshal() throws IOException {
    marshaler.addLong(key, "key");
    marshaler.addInt(index, "index");
    marshaler.addDKSObject(payload,"payload");

  }

  public void unmarshal() throws IOException {
    key   = marshaler.remLong("key");
    index = marshaler.remInt("index");
    payload = marshaler.remDKSObject("payload");
  }
}
