/**
 * Message sent by the multicast DHT to join a multicast group
 */
package org.kth.dks.dks_dht;

import java.io.IOException;

import org.kth.dks.dks_comm.DKSRef;
import org.kth.dks.dks_marshal.DKSMessage;

public class MCastGroupInfoMsg extends DKSMessage {
    public final static String NAME= "MCASTGROUPINFOMSG";
    private long groupId;
    DKSRef source;

    public String getName() { return NAME; }
    public long getGroupId() { return groupId; }
    public DKSRef getSource() { return source; }

    public MCastGroupInfoMsg() {

    }

    public MCastGroupInfoMsg(long id, DKSRef source) {

      groupId=id;
      this.source = source;
    }

    public void marshal() throws IOException {
      marshaler.addLong(groupId, "gid");
      marshaler.addDKSRef(source, "source");

   }

   public void unmarshal() throws IOException {
     groupId = marshaler.remLong("gid");
     source  = marshaler.remDKSRef("source");
    }
}
