/**
 * Message sent by the multicast DHT to join a multicast group
 */
package org.kth.dks.dks_dht;

import java.io.IOException;

import org.kth.dks.dks_comm.DKSRef;
import org.kth.dks.dks_marshal.DKSMessage;

public class JoinMCastGroupMsg extends DKSMessage {
    public final static String NAME= "JOINMCASTGROUPMSG";
    private long groupId;
    DKSRef groupNode;

    public String getName() { return NAME; }
    public long getGroupId() { return groupId; }
    public DKSRef getGroupNode() { return groupNode; }

    public JoinMCastGroupMsg() {

    }

    public JoinMCastGroupMsg(long id, DKSRef groupNode) {

      groupId=id;
      this.groupNode = groupNode;
    }


    public void marshal() throws IOException {
      marshaler.addLong(groupId, "gid");
      marshaler.addDKSRef(groupNode, "gnode");

    }

    public void unmarshal() throws IOException {
      groupId   = marshaler.remLong("gid");
      groupNode = marshaler.remDKSRef("gnode");
    }
}
