/*
 * Encapsulation of DHT data items
 */
package org.kth.dks.dks_dht;

import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;

public class DHTStatisticsItem implements Serializable {

    /*
     * This is the actual data, it is a list of DHTStatisticsPairs
     */
    public LinkedList entries = new LinkedList();
    public boolean insert;
    public boolean lookup;
    
    public DHTStatisticsItem(boolean insert, boolean lookup) {
	this.insert = insert;
	this.lookup = lookup;
    }

    public void newEntry(Long o, int cc, List values) {
	entries.add(new DHTStatisticsPair(o,  values, cc));
    }

    

    public boolean equals(Object o){	    
	if (o==this)
	    return true;
	else if (!(o instanceof DHTStatisticsItem))
	    return false;
	else{
	    DHTStatisticsItem thisO = (DHTStatisticsItem) o; 
	    return thisO.insert == insert && thisO.lookup == lookup && thisO.entries.equals(this.entries);
	}
    }
}
    
