package org.kth.dks.dks_dht;

import java.io.IOException;

import org.apache.log4j.Logger;
import org.kth.dks.DKSObject;
import org.kth.dks.dks_marshal.DKSMessage;
import org.kth.dks.util.DKSPrintTypes;

public class DHTStateTransferMsg extends DKSMessage {
	private final Logger log = Logger.getLogger(DHTStateTransferMsg.class);
	public static final String NAME= "DHTSTATETRANSFERMSG";
    private DKSObject[] payload = new DKSObject[0];
    private long key;
    private int StateTransfer;
    public static final int LASTMSG=0;
    public static final int DATATRANSFER=1;
    public static final int LASTMSGRECEIVED=2;
    public static final int STATEREQUEST=3;
    private int type;

    public String getName() { return NAME; }
    public DKSObject[] getPayload(){ return payload;}
    public long getKey() {return key;}
    public long getType() {return type;}

    public DHTStateTransferMsg() {

    }

    public DHTStateTransferMsg( long k,DKSObject[] pld) {

      key=k;
      payload=pld;
      type=DATATRANSFER;
    }

    public DHTStateTransferMsg( long k, int t) {

      key=k;
      type=t;
    }

  public void marshal() throws IOException {
    marshaler.addLong(key, "key");
    marshaler.addInt(type, "type");
    marshaler.addInt(payload.length, "arrlen");
    for (int i=0; i<payload.length; i++) {
      marshaler.addDKSObject(payload[i], "payload"+(i+1));
    }

  }

    public void unmarshal() throws IOException {
      key     = marshaler.remLong("key");
      type    = marshaler.remInt("type");
      int len = marshaler.remInt("arrlen");
      payload = new DKSObject[len];
      for (int i=0; i<len; i++) {
        payload[i] = marshaler.remDKSObject("payload"+(i+1));
      }

      log.debug("in DHTSendstateunmarshal.");

      log.debug("Unmarshalling a "+type+" message.");
    }
}
