package org.kth.dks.dks_dht;

import java.io.IOException;

import org.kth.dks.DKSObject;
import org.kth.dks.dks_marshal.DKSMessage;

public class AddToBindingMsg extends DKSMessage {
  public final static String NAME = "ADDTOBINDINGMSG";
  private DKSObject payload = null;
  private long key;

  public String getName() {
    return NAME;
  }

  public AddToBindingMsg() {
  }

  public AddToBindingMsg(long id, DKSObject pld) {
    key = id;
    payload = pld;
  }

  public DKSObject getPayload() {
    return payload;
  }

  public long getKey() {
    return key;
  }

  public void marshal() throws IOException {
    marshaler.addLong(key, "key");
    marshaler.addDKSObject(payload, "payload");

  }

  public void unmarshal() throws IOException {
    key     = marshaler.remLong("key");
    payload = marshaler.remDKSObject("payload");
  }
}
