package org.kth.dks.dks_dht;

import java.io.IOException;

import org.kth.dks.DKSObject;
import org.kth.dks.dks_marshal.DKSMessage;

public class AddItemMsg extends DKSMessage {
  public final static String NAME = "ADDITEMMSG";
  public DKSObject payload = null;
  public long key;
  public int index;
  public String getName() {
    return NAME;
  }

  public AddItemMsg() {
  }

  public AddItemMsg(long id, int i, DKSObject pld) {
    key = id;
    payload = pld;
    index = i ;
  }


  public void marshal() throws IOException {
    marshaler.addLong(key, "key");
    marshaler.addDKSObject(payload, "payload");
    marshaler.addInt(index, "index");

  }

  public void unmarshal() throws IOException {
    key     = marshaler.remLong("key");
    payload = marshaler.remDKSObject("payload");
    index   = marshaler.remInt("index");
  }
}
