package org.kth.dks;

import org.kth.dks.dks_comm.DKSRef;
import org.kth.dks.dks_dht.DKSDHTCallback;
import org.kth.dks.dks_exceptions.DKSIdentifierAlreadyTaken;
import org.kth.dks.dks_exceptions.DKSMCastNoSouchGroup;
import org.kth.dks.dks_exceptions.DKSRefNoResponse;
import org.kth.dks.dks_exceptions.DKSTooManyRestartJoins;
/**
 *
 * This interface is an extension to the DKSDHTInterface with support
 * for creating multicast groups
 * 
 */

public interface DKSMCastDHTInterface extends DKSDHTInterface {

    /**
     * Create a new multicast group with a specific group
     * id. Automatically become a member of the group if the group
     * does not exists. If the group already exists
     * DKSNodeAlreadyRegistered will be thrown.
     *
     * Events in the newly created group will be delivered to the
     * callback.
     *
     */
    public DKSMCastDHTInterface createGroup(long gid, DKSDHTCallback cb)
	throws DKSIdentifierAlreadyTaken, DKSTooManyRestartJoins;

    /**
     * Join an existing multicast group with a specific group id. If
     * the group does not exist DKSMCastNoSouchGroup is thrown.
     *
     * Events in the newly created group will be delivered to the
     * callback.
     */
    public DKSMCastDHTInterface joinGroup(long gid, DKSDHTCallback cb)
	throws DKSMCastNoSouchGroup,
	       DKSIdentifierAlreadyTaken,
	       DKSRefNoResponse;

    /**
     * Return the members of the group.
     *
     */
    public DKSRef[] getGroupInfo(long gid) throws DKSMCastNoSouchGroup;

    /**
     * Install a message message handler, @see
     * ObjectAdapter.addMsgHandler()
     *
     */
    public boolean addMsgHandler(String messageClassZ,
				 String handlerClassZ,
				 String handlerMethodZ,
				 Object handlerObject);
}
