package org.kth.dks;

import java.io.IOException;
import java.io.OutputStream;
import java.util.List;

/**
 *
 *  The data stored in a DHT can be collected at a central point 
 *  and stored, in the form of a snapshot. Collecting all entries
 *  in a DHT is a non atomic operation that takes time. Moreover, 
 *  if the state of the entries is changed while the snaphot is taken, 
 *  the snapshot can be incorrect. 
 *
 *  A call to the snapshot interfacew returns a snapsoht object that 
 *  is filled by the DHT over time. The snapshot object can be queried 
 *  for its status, and saved to disk when filled. 
 * 
 */

public interface DHTSnapShotInterface {


    /**
     * Returns the size of the non-filled interval  
     *
     */
    public long intervalNotReceived(); 
    
    /**
     * Returns true if the snapshot object has received the  
     * complete snapshot. 
     */
    
    public boolean isDone();
	
    public boolean waitForDone(int timeOut); 
    
    public void saveSnapShot(OutputStream oss) throws IOException ; 

    public List getItems(); 
}

