/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.maven.plugin.stubgen;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.shared.io.scan.mapping.SourceMapping;
import org.apache.maven.shared.io.scan.mapping.SuffixMapping;
import org.apache.maven.shared.model.fileset.FileSet;
import org.codehaus.groovy.maven.feature.Component;
import org.codehaus.groovy.maven.plugin.CompilerMojoSupport;
import org.codehaus.groovy.maven.runtime.StubCompiler;

public abstract class AbstractGenerateStubsMojo
extends CompilerMojoSupport {
    static final /* synthetic */ boolean $assertionsDisabled;

    protected AbstractGenerateStubsMojo() {
        super(StubCompiler.KEY);
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        super.execute();
        try {
            this.resetStubModifiedDates();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to get output folder.", e);
        }
    }

    private void resetStubModifiedDates() throws Exception {
        List stubs = this.recurseFiles(this.getOutputDirectory());
        Iterator i = stubs.iterator();
        while (i.hasNext()) {
            File file = (File)i.next();
            file.setLastModified(0L);
        }
    }

    private List recurseFiles(File folder) {
        if (!$assertionsDisabled && folder == null) {
            throw new AssertionError();
        }
        ArrayList<File> result = new ArrayList<File>();
        File[] files = folder.listFiles();
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                if (files[i].isDirectory()) {
                    result.addAll(this.recurseFiles(files[i]));
                    continue;
                }
                result.add(files[i]);
            }
        }
        return result;
    }

    protected abstract void forceCompile(File var1);

    protected void process(Component component) throws Exception {
        if (!$assertionsDisabled && component == null) {
            throw new AssertionError();
        }
        StubCompiler compiler = (StubCompiler)component;
        compiler.setTargetDirectory(this.getOutputDirectory());
        this.compile(compiler, this.sources != null ? this.sources : this.getDefaultSources());
    }

    protected void compile(StubCompiler compiler, FileSet[] sources) throws Exception {
        if (!$assertionsDisabled && compiler == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && sources == null) {
            throw new AssertionError();
        }
        this.addSourceRoot(this.getOutputDirectory());
        for (int i = 0; i < sources.length; ++i) {
            this.addSourceRoot(sources[i]);
            SourceMapping[] mappings = new SourceMapping[]{new SuffixMapping(".groovy", ".java")};
            File[] files = this.scanForSources(sources[i], mappings);
            for (int j = 0; j < files.length; ++j) {
                this.log.debug(" + " + files[j]);
                compiler.add(files[j]);
                this.forceCompile(files[j]);
            }
        }
        int count = compiler.compile();
        if (count == 0) {
            this.log.info("No sources found for Java stub generation");
        } else {
            this.log.info("Generated " + count + " Java stub" + (count > 1 ? "s" : ""));
        }
    }

    private void addSourceRoot(FileSet fileSet) throws IOException {
        if (!$assertionsDisabled && fileSet == null) {
            throw new AssertionError();
        }
        File basedir = new File(fileSet.getDirectory());
        this.addSourceRoot(basedir);
    }

    static {
        $assertionsDisabled = !AbstractGenerateStubsMojo.class.desiredAssertionStatus();
    }
}

