/*
 * Decompiled with CFR 0.152.
 */
package org.kie.spring;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.kie.api.builder.ReleaseId;
import org.kie.api.builder.model.KieModuleModel;
import org.kie.spring.KModuleBeanFactoryPostProcessor;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.context.support.FileSystemXmlApplicationContext;

public class KModuleSpringMarshaller {
    public static KieModuleModel fromXML(File kModuleFile) {
        return KModuleSpringMarshaller.fromXML(kModuleFile, null);
    }

    public static KieModuleModel fromXML(File kModuleFile, ReleaseId releaseId) {
        ClassPathXmlApplicationContext context = new ClassPathXmlApplicationContext(kModuleFile.getAbsolutePath());
        context.setConfigLocation(kModuleFile.getAbsolutePath());
        context.refresh();
        context.registerShutdownHook();
        return null;
    }

    public static KieModuleModel fromXML(URL kModuleUrl, String fixedPath, ReleaseId releaseId) {
        ClassPathXmlApplicationContext context = new ClassPathXmlApplicationContext();
        KModuleBeanFactoryPostProcessor beanFactoryPostProcessor = new KModuleBeanFactoryPostProcessor(kModuleUrl, fixedPath, (ApplicationContext)context);
        beanFactoryPostProcessor.setReleaseId(releaseId);
        context.addBeanFactoryPostProcessor((BeanFactoryPostProcessor)beanFactoryPostProcessor);
        context.setConfigLocation(kModuleUrl.toExternalForm());
        context.refresh();
        context.registerShutdownHook();
        return null;
    }

    public static KieModuleModel fromXML(URL kModuleUrl, ReleaseId releaseId) {
        return KModuleSpringMarshaller.fromXML(kModuleUrl, null, releaseId);
    }

    public static KieModuleModel fromXML(URL kModuleUrl, String fixedPath) {
        return KModuleSpringMarshaller.fromXML(kModuleUrl, fixedPath, null);
    }

    public static KieModuleModel fromXML(URL kModuleUrl) {
        return KModuleSpringMarshaller.fromXML(kModuleUrl, null, null);
    }

    public static KieModuleModel fromXML(String kmoduleXML) {
        FileSystemXmlApplicationContext context = new FileSystemXmlApplicationContext();
        try {
            File tempFile = File.createTempFile("kmodule", "springXML");
            tempFile.deleteOnExit();
            context.setConfigLocation(tempFile.getAbsolutePath());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        context.refresh();
        context.registerShutdownHook();
        return null;
    }
}

