/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.x509;

import java.security.GeneralSecurityException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import org.jboss.logging.Logger;
import org.keycloak.common.util.PemException;
import org.keycloak.http.HttpRequest;
import org.keycloak.services.x509.X509ClientCertificateLookup;

public abstract class AbstractClientCertificateFromHttpHeadersLookup
implements X509ClientCertificateLookup {
    protected static final Logger logger = Logger.getLogger(AbstractClientCertificateFromHttpHeadersLookup.class);
    protected final String sslClientCertHttpHeader;
    protected final String sslCertChainHttpHeaderPrefix;
    protected final int certificateChainLength;

    public AbstractClientCertificateFromHttpHeadersLookup(String sslCientCertHttpHeader, String sslCertChainHttpHeaderPrefix, int certificateChainLength) {
        if (sslCientCertHttpHeader == null) {
            throw new IllegalArgumentException("sslClientCertHttpHeader");
        }
        if (certificateChainLength < 0) {
            throw new IllegalArgumentException("certificateChainLength must be greater or equal to zero");
        }
        this.sslClientCertHttpHeader = sslCientCertHttpHeader;
        this.sslCertChainHttpHeaderPrefix = sslCertChainHttpHeaderPrefix;
        this.certificateChainLength = certificateChainLength;
    }

    public void close() {
    }

    static String getHeaderValue(HttpRequest httpRequest, String headerName) {
        return (String)httpRequest.getHttpHeaders().getRequestHeaders().getFirst((Object)headerName);
    }

    private static String trimDoubleQuotes(String quotedString) {
        if (quotedString == null) {
            return null;
        }
        int len = quotedString.length();
        if (len > 1 && quotedString.charAt(0) == '\"' && quotedString.charAt(len - 1) == '\"') {
            logger.trace((Object)"Detected a certificate enclosed in double quotes");
            return quotedString.substring(1, len - 1);
        }
        return quotedString;
    }

    protected abstract X509Certificate decodeCertificateFromPem(String var1) throws PemException;

    protected X509Certificate getCertificateFromHttpHeader(HttpRequest request, String httpHeader) throws GeneralSecurityException {
        String encodedCertificate = AbstractClientCertificateFromHttpHeadersLookup.getHeaderValue(request, httpHeader);
        if ((encodedCertificate = AbstractClientCertificateFromHttpHeadersLookup.trimDoubleQuotes(encodedCertificate)) == null || encodedCertificate.trim().length() == 0) {
            logger.warnf("HTTP header \"%s\" is empty", (Object)httpHeader);
            return null;
        }
        try {
            X509Certificate cert = this.decodeCertificateFromPem(encodedCertificate);
            if (cert == null) {
                logger.warnf("HTTP header \"%s\" does not contain a valid x.509 certificate\n%s", (Object)httpHeader, (Object)encodedCertificate);
            } else {
                logger.debugf("Found a valid x.509 certificate in \"%s\" HTTP header", (Object)httpHeader);
            }
            return cert;
        }
        catch (PemException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new GeneralSecurityException(e);
        }
    }

    @Override
    public X509Certificate[] getCertificateChain(HttpRequest httpRequest) throws GeneralSecurityException {
        ArrayList<X509Certificate> chain = new ArrayList<X509Certificate>();
        X509Certificate cert = this.getCertificateFromHttpHeader(httpRequest, this.sslClientCertHttpHeader);
        if (cert != null) {
            chain.add(cert);
            for (int i = 0; i < this.certificateChainLength; ++i) {
                try {
                    String s = String.format("%s_%s", this.sslCertChainHttpHeaderPrefix, i);
                    cert = this.getCertificateFromHttpHeader(httpRequest, s);
                    if (cert == null) continue;
                    chain.add(cert);
                    continue;
                }
                catch (GeneralSecurityException e) {
                    logger.warn((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        return chain.toArray(new X509Certificate[0]);
    }
}

