/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.truststore;

import java.io.File;
import java.net.URL;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Collections;
import org.junit.Assert;
import org.junit.Test;
import org.keycloak.truststore.TruststoreBuilder;

public class TruststoreBuilderTest {
    @Test
    public void testMergedTrustStore() throws Exception {
        URL url = TruststoreBuilderTest.class.getResource("/truststores/keycloak.pem");
        KeyStore storeWithoutDefaults = TruststoreBuilder.createMergedTruststore((String[])new String[]{url.getPath()}, (boolean)false);
        ArrayList<String> storeWithoutDefaultsAliases = Collections.list(storeWithoutDefaults.aliases());
        Assert.assertEquals((long)2L, (long)storeWithoutDefaultsAliases.size());
        KeyStore storeWithDefaults = TruststoreBuilder.createMergedTruststore((String[])new String[]{url.getPath()}, (boolean)true);
        ArrayList<String> storeWithDefaultsAliases = Collections.list(storeWithDefaults.aliases());
        int certs = storeWithDefaultsAliases.size();
        Assert.assertTrue((certs > 2 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)storeWithDefaultsAliases.containsAll(storeWithoutDefaultsAliases));
        File saved = TruststoreBuilder.saveTruststore((KeyStore)storeWithDefaults, (String)"target", null);
        KeyStore savedLoaded = TruststoreBuilder.loadStore((String)saved.getAbsolutePath(), (String)"PKCS12", null);
        Assert.assertEquals((long)certs, (long)Collections.list(savedLoaded.aliases()).size());
    }

    @Test
    public void testMergedTrustStoreFromDirectory() throws Exception {
        URL url = TruststoreBuilderTest.class.getResource("/truststores/keycloak.pem");
        KeyStore storeWithoutDefaults = TruststoreBuilder.createMergedTruststore((String[])new String[]{new File(url.getPath()).getParent()}, (boolean)false);
        ArrayList<String> storeWithoutDefaultsAliases = Collections.list(storeWithoutDefaults.aliases());
        Assert.assertEquals((long)2L, (long)storeWithoutDefaultsAliases.size());
    }

    @Test
    public void testFailsWithInvalidFile() throws Exception {
        URL url = TruststoreBuilderTest.class.getResource("/truststores/invalid");
        Assert.assertThrows(RuntimeException.class, () -> TruststoreBuilder.createMergedTruststore((String[])new String[]{new File(url.getPath()).getAbsolutePath()}, (boolean)false));
    }
}

