/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.theme;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import org.junit.Assert;
import org.junit.Test;
import org.keycloak.theme.PropertiesUtil;

public class PropertiesUtilTest {
    String valueWithUmlaut = "Umlaut: \u00e4\u00f6\u00fc";
    String key = "key";
    String propertyLine = this.key + "=" + this.valueWithUmlaut;

    @Test
    public void testEncodingIso() throws Exception {
        this.testWithEncoding(StandardCharsets.ISO_8859_1);
    }

    @Test
    public void testEncodingUtf8() throws Exception {
        this.testWithEncoding(StandardCharsets.UTF_8);
    }

    @Test
    public void testIfValueContainsSpecialCharacters() {
        Assert.assertNotEquals((Object)this.valueWithUmlaut.getBytes(StandardCharsets.UTF_8), (Object)this.valueWithUmlaut.getBytes(StandardCharsets.ISO_8859_1));
    }

    private void testWithEncoding(Charset charset) throws IOException {
        Properties p = new Properties();
        try (ByteArrayInputStream stream = new ByteArrayInputStream(this.propertyLine.getBytes(charset));){
            PropertiesUtil.readCharsetAware((Properties)p, (InputStream)stream);
        }
        Assert.assertEquals((Object)p.get(this.key), (Object)this.valueWithUmlaut);
    }
}

