/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.connections.httpclient;

import java.lang.reflect.Field;
import java.util.concurrent.TimeUnit;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.impl.client.CloseableHttpClient;
import org.junit.Assert;
import org.junit.Test;
import org.keycloak.connections.httpclient.HttpClientBuilder;

public class HttpClientBuilderTest {
    @Test
    public void testDefaultBuilder() throws NoSuchFieldException, IllegalAccessException {
        CloseableHttpClient httpClient = new HttpClientBuilder().build();
        RequestConfig requestConfig = HttpClientBuilderTest.getRequestConfig(httpClient);
        Assert.assertEquals((String)"Default socket timeout is -1 and can be converted by TimeUnit", (long)-1L, (long)requestConfig.getSocketTimeout());
        Assert.assertEquals((String)"Default connect timeout is -1 and can be converted by TimeUnit", (long)-1L, (long)requestConfig.getConnectTimeout());
    }

    @Test
    public void testTimeUnitSeconds() throws NoSuchFieldException, IllegalAccessException {
        HttpClientBuilder httpClientBuilder = new HttpClientBuilder();
        httpClientBuilder.socketTimeout(2L, TimeUnit.SECONDS).establishConnectionTimeout(1L, TimeUnit.SECONDS);
        CloseableHttpClient httpClient = httpClientBuilder.build();
        RequestConfig requestConfig = HttpClientBuilderTest.getRequestConfig(httpClient);
        Assert.assertEquals((String)"Socket timeout is converted to milliseconds", (long)2000L, (long)requestConfig.getSocketTimeout());
        Assert.assertEquals((String)"Connect timeout is converted to milliseconds", (long)1000L, (long)requestConfig.getConnectTimeout());
    }

    @Test
    public void testTimeUnitMilliSeconds() throws NoSuchFieldException, IllegalAccessException {
        HttpClientBuilder httpClientBuilder = new HttpClientBuilder();
        httpClientBuilder.socketTimeout(2000L, TimeUnit.MILLISECONDS).establishConnectionTimeout(1000L, TimeUnit.MILLISECONDS);
        CloseableHttpClient httpClient = httpClientBuilder.build();
        RequestConfig requestConfig = HttpClientBuilderTest.getRequestConfig(httpClient);
        Assert.assertEquals((String)"Socket timeout is still in milliseconds", (long)2000L, (long)requestConfig.getSocketTimeout());
        Assert.assertEquals((String)"Connect timeout is still in milliseconds", (long)1000L, (long)requestConfig.getConnectTimeout());
    }

    private static RequestConfig getRequestConfig(CloseableHttpClient httpClient) throws NoSuchFieldException, IllegalAccessException {
        Field defaultConfig = httpClient.getClass().getDeclaredField("defaultConfig");
        defaultConfig.setAccessible(true);
        return (RequestConfig)defaultConfig.get(httpClient);
    }
}

