/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication.authenticators.x509;

import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.cert.X509Certificate;
import java.util.Date;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.keycloak.authentication.authenticators.x509.CertificateValidator;
import org.keycloak.common.crypto.CryptoIntegration;
import org.keycloak.rule.CryptoInitRule;

public class CertificateValidatorTest {
    @ClassRule
    public static CryptoInitRule cryptoInitRule = new CryptoInitRule();

    @Test
    public void testValidityOfCertificatesSuccess() throws GeneralSecurityException {
        KeyPairGenerator kpg = CryptoIntegration.getProvider().getKeyPairGen("RSA");
        kpg.initialize(512);
        KeyPair keyPair = kpg.generateKeyPair();
        X509Certificate certificate = CryptoIntegration.getProvider().getCertificateUtils().createServicesTestCertificate("CN=keycloak-test", new Date(), new Date(System.currentTimeMillis() + 60000L), keyPair, new String[0]);
        CertificateValidator.CertificateValidatorBuilder builder = new CertificateValidator.CertificateValidatorBuilder();
        CertificateValidator validator = builder.timestampValidation().enabled(true).build(new X509Certificate[]{certificate});
        try {
            validator.validateTimestamps();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Assert.fail((String)ex.getMessage());
        }
    }

    @Test
    public void testValidityOfCertificatesNotValidYet() throws GeneralSecurityException {
        KeyPairGenerator kpg = CryptoIntegration.getProvider().getKeyPairGen("RSA");
        kpg.initialize(512);
        KeyPair keyPair = kpg.generateKeyPair();
        X509Certificate certificate = CryptoIntegration.getProvider().getCertificateUtils().createServicesTestCertificate("CN=keycloak-test", new Date(System.currentTimeMillis() + 60000L), new Date(System.currentTimeMillis() + 60000L), keyPair, new String[0]);
        CertificateValidator.CertificateValidatorBuilder builder = new CertificateValidator.CertificateValidatorBuilder();
        CertificateValidator validator = builder.timestampValidation().enabled(true).build(new X509Certificate[]{certificate});
        try {
            validator.validateTimestamps();
            Assert.fail((String)"certificate validation must fail for certificate is not valid yet");
        }
        catch (Exception ex) {
            MatcherAssert.assertThat((Object)ex.getMessage(), (Matcher)Matchers.containsString((String)"not valid yet"));
            Assert.assertEquals(GeneralSecurityException.class, ex.getClass());
        }
    }

    @Test
    public void testValidityOfCertificatesHasExpired() throws GeneralSecurityException {
        KeyPairGenerator kpg = CryptoIntegration.getProvider().getKeyPairGen("RSA");
        kpg.initialize(512);
        KeyPair keyPair = kpg.generateKeyPair();
        X509Certificate certificate = CryptoIntegration.getProvider().getCertificateUtils().createServicesTestCertificate("CN=keycloak-test", new Date(System.currentTimeMillis() - 120000L), new Date(System.currentTimeMillis() - 60000L), keyPair, new String[0]);
        CertificateValidator.CertificateValidatorBuilder builder = new CertificateValidator.CertificateValidatorBuilder();
        CertificateValidator validator = builder.timestampValidation().enabled(true).build(new X509Certificate[]{certificate});
        try {
            validator.validateTimestamps();
            Assert.fail((String)"certificate validation must fail for certificate has expired");
        }
        catch (Exception ex) {
            MatcherAssert.assertThat((Object)ex.getMessage(), (Matcher)Matchers.containsString((String)"has expired"));
            Assert.assertEquals(GeneralSecurityException.class, ex.getClass());
        }
    }

    @Test
    public void testCertificatePolicyModeAllNotRequestedAndNotPresent() throws GeneralSecurityException {
        this.testCertificatePolicyValidation(null, "All", new String[0]);
    }

    @Test
    public void testCertificatePolicyModeAllNotRequestedAndOnePresent() throws GeneralSecurityException {
        this.testCertificatePolicyValidation(null, "All", "1.3.76.16.2.1");
    }

    @Test
    public void testCertificatePolicyModeAllNotRequestedAndTwoPresent() throws GeneralSecurityException {
        this.testCertificatePolicyValidation(null, "All", "1.3.76.16.2.1", "1.2.3.4.5.6");
    }

    @Test(expected=GeneralSecurityException.class)
    public void testCertificatePolicyModeAllOneRequestedAndNotPresent() throws GeneralSecurityException {
        this.testCertificatePolicyValidation("1.3.76.16.2.1", "All", new String[0]);
    }

    @Test
    public void testCertificatePolicyModeAllOneRequestedAndOnePresent() throws GeneralSecurityException {
        this.testCertificatePolicyValidation("1.3.76.16.2.1", "All", "1.3.76.16.2.1");
    }

    @Test(expected=GeneralSecurityException.class)
    public void testCertificatePolicyModeAllOneRequestedAndOnePresentDifferent() throws GeneralSecurityException {
        this.testCertificatePolicyValidation("1.3.76.16.2.1", "All", "1.2.3.4.5.6");
    }

    @Test
    public void testCertificatePolicyModeAllOneRequestedAndTwoPresent() throws GeneralSecurityException {
        this.testCertificatePolicyValidation("1.3.76.16.2.1", "All", "1.3.76.16.2.1", "1.2.3.4.5.6");
    }

    @Test(expected=GeneralSecurityException.class)
    public void testCertificatePolicyModeAllOneRequestedAndTwoPresentDifferent() throws GeneralSecurityException {
        this.testCertificatePolicyValidation("1.3.76.16.2.1", "All", "1.2.3.4.5", "1.2.3.4.5.6");
    }

    @Test(expected=GeneralSecurityException.class)
    public void testCertificatePolicyModeAllTwoRequestedAndNotPresent() throws GeneralSecurityException {
        this.testCertificatePolicyValidation("1.3.76.16.2.1,1.2.3.4.5.6", "All", new String[0]);
    }

    @Test(expected=GeneralSecurityException.class)
    public void testCertificatePolicyModeAllTwoRequestedAndOnePresent() throws GeneralSecurityException {
        this.testCertificatePolicyValidation("1.3.76.16.2.1,1.2.3.4.5.6", "All", "1.3.76.16.2.1");
    }

    @Test(expected=GeneralSecurityException.class)
    public void testCertificatePolicyModeAllTwoRequestedAndOnePresentDifferent() throws GeneralSecurityException {
        this.testCertificatePolicyValidation("1.3.76.16.2.1,1.2.3.4.5.6", "All", "1.2.3.4");
    }

    @Test
    public void testCertificatePolicyModeAllTwoRequestedAndTwoPresent() throws GeneralSecurityException {
        this.testCertificatePolicyValidation("1.3.76.16.2.1,1.2.3.4.5.6", "All", "1.3.76.16.2.1", "1.2.3.4.5.6");
    }

    @Test
    public void testCertificatePolicyModeAnyNotRequestedAndNotPresent() throws GeneralSecurityException {
        this.testCertificatePolicyValidation(null, "Any", new String[0]);
    }

    @Test
    public void testCertificatePolicyModeAnyNotRequestedAndOnePresent() throws GeneralSecurityException {
        this.testCertificatePolicyValidation(null, "Any", "1.3.76.16.2.1");
    }

    @Test
    public void testCertificatePolicyModeAnyNotRequestedAndTwoPresent() throws GeneralSecurityException {
        this.testCertificatePolicyValidation(null, "Any", "1.3.76.16.2.1", "1.2.3.4.5.6");
    }

    @Test(expected=GeneralSecurityException.class)
    public void testCertificatePolicyModeAnyOneRequestedAndNotPresent() throws GeneralSecurityException {
        this.testCertificatePolicyValidation("1.3.76.16.2.1", "Any", new String[0]);
    }

    @Test
    public void testCertificatePolicyModeAnyOneRequestedAndOnePresent() throws GeneralSecurityException {
        this.testCertificatePolicyValidation("1.3.76.16.2.1", "Any", "1.3.76.16.2.1");
    }

    @Test(expected=GeneralSecurityException.class)
    public void testCertificatePolicyModeAnyOneRequestedAndOnePresentDifferent() throws GeneralSecurityException {
        this.testCertificatePolicyValidation("1.3.76.16.2.1", "Any", "1.2.3.4.5.6");
    }

    @Test
    public void testCertificatePolicyModeAnyOneRequestedAndTwoPresent() throws GeneralSecurityException {
        this.testCertificatePolicyValidation("1.3.76.16.2.1", "Any", "1.3.76.16.2.1", "1.2.3.4.5.6");
    }

    @Test(expected=GeneralSecurityException.class)
    public void testCertificatePolicyModeAnyOneRequestedAndTwoPresentDifferent() throws GeneralSecurityException {
        this.testCertificatePolicyValidation("1.3.76.16.2.1", "Any", "1.2.3.4.5", "1.2.3.4.5.6");
    }

    @Test(expected=GeneralSecurityException.class)
    public void testCertificatePolicyModeAnyTwoRequestedAndNotPresent() throws GeneralSecurityException {
        this.testCertificatePolicyValidation("1.3.76.16.2.1,1.2.3.4.5.6", "Any", new String[0]);
    }

    @Test
    public void testCertificatePolicyModeAnyTwoRequestedAndOnePresent() throws GeneralSecurityException {
        this.testCertificatePolicyValidation("1.3.76.16.2.1,1.2.3.4.5.6", "Any", "1.3.76.16.2.1");
    }

    @Test(expected=GeneralSecurityException.class)
    public void testCertificatePolicyModeAnyTwoRequestedAndOnePresentDifferent() throws GeneralSecurityException {
        this.testCertificatePolicyValidation("1.3.76.16.2.1,1.2.3.4.5.6", "Any", "1.2.3.4");
    }

    @Test
    public void testCertificatePolicyModeAnyTwoRequestedAndTwoPresent() throws GeneralSecurityException {
        this.testCertificatePolicyValidation("1.3.76.16.2.1,1.2.3.4.5.6", "Any", "1.3.76.16.2.1", "1.2.3.4.5.6");
    }

    private void testCertificatePolicyValidation(String expectedPolicy, String mode, String ... certificatePolicyOid) throws GeneralSecurityException {
        KeyPairGenerator kpg = CryptoIntegration.getProvider().getKeyPairGen("RSA");
        kpg.initialize(512);
        KeyPair keyPair = kpg.generateKeyPair();
        X509Certificate certificate = CryptoIntegration.getProvider().getCertificateUtils().createServicesTestCertificate("CN=keycloak-test", new Date(System.currentTimeMillis() - 120000L), new Date(System.currentTimeMillis() - 60000L), keyPair, certificatePolicyOid);
        CertificateValidator.CertificateValidatorBuilder builder = new CertificateValidator.CertificateValidatorBuilder();
        CertificateValidator validator = builder.certificatePolicy().mode(mode).parse(expectedPolicy).build(new X509Certificate[]{certificate});
        validator.validatePolicy();
    }
}

