/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.validate.validators;

import java.util.Collection;
import org.keycloak.validate.SimpleValidator;
import org.keycloak.validate.ValidationContext;
import org.keycloak.validate.ValidationError;
import org.keycloak.validate.ValidatorConfig;

public class NotBlankValidator
implements SimpleValidator {
    public static final String ID = "not-blank";
    public static final String MESSAGE_BLANK = "error-invalid-blank";
    public static final NotBlankValidator INSTANCE = new NotBlankValidator();

    public String getId() {
        return ID;
    }

    public ValidationContext validate(Object input, String inputHint, ValidationContext context, ValidatorConfig config) {
        if (input == null) {
            context.addError(new ValidationError(ID, inputHint, MESSAGE_BLANK, new Object[]{input}));
        } else if (input instanceof String) {
            this.validateStringValue((String)input, inputHint, context, config);
        } else if (input instanceof Collection) {
            Collection values = (Collection)input;
            if (!values.isEmpty()) {
                for (Object value : values) {
                    if (!(value instanceof String)) {
                        context.addError(new ValidationError(this.getId(), inputHint, "error-invalid-value", new Object[]{input}));
                        return context;
                    }
                    if (this.validateStringValue((String)value, inputHint, context, config)) continue;
                    return context;
                }
            } else {
                context.addError(new ValidationError(ID, inputHint, MESSAGE_BLANK, new Object[]{input}));
            }
        } else {
            context.addError(new ValidationError(ID, inputHint, "error-invalid-value", new Object[]{input}));
        }
        return context;
    }

    protected boolean validateStringValue(String value, String inputHint, ValidationContext context, ValidatorConfig config) {
        if (value == null || value.trim().length() == 0) {
            context.addError(new ValidationError(ID, inputHint, MESSAGE_BLANK, new Object[]{value}));
            return false;
        }
        return true;
    }
}

