/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.saml.profile.ecp;

import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPHeaderElement;
import javax.xml.soap.SOAPMessage;
import org.keycloak.adapters.saml.AbstractInitiateLogin;
import org.keycloak.adapters.saml.OnSessionCreated;
import org.keycloak.adapters.saml.SamlDeployment;
import org.keycloak.adapters.saml.SamlSessionStore;
import org.keycloak.adapters.saml.profile.AbstractSamlAuthenticationHandler;
import org.keycloak.adapters.saml.profile.SamlAuthenticationHandler;
import org.keycloak.adapters.saml.profile.SamlInvocationContext;
import org.keycloak.adapters.spi.AuthOutcome;
import org.keycloak.adapters.spi.HttpFacade;
import org.keycloak.dom.saml.v2.protocol.LogoutRequestType;
import org.keycloak.saml.BaseSAML2BindingBuilder;
import org.keycloak.saml.SAML2AuthnRequestBuilder;
import org.keycloak.saml.common.constants.JBossSAMLConstants;
import org.keycloak.saml.common.constants.JBossSAMLURIConstants;
import org.keycloak.saml.processing.core.saml.v2.util.DocumentUtil;
import org.keycloak.saml.processing.web.util.PostBindingUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class EcpAuthenticationHandler
extends AbstractSamlAuthenticationHandler {
    public static final String PAOS_HEADER = "PAOS";
    public static final String PAOS_CONTENT_TYPE = "application/vnd.paos+xml";
    private static final String NS_PREFIX_PROFILE_ECP = "ecp";
    private static final String NS_PREFIX_SAML_PROTOCOL = "samlp";
    private static final String NS_PREFIX_SAML_ASSERTION = "saml";
    private static final String NS_PREFIX_PAOS_BINDING = "paos";

    public static boolean canHandle(HttpFacade httpFacade) {
        HttpFacade.Request request = httpFacade.getRequest();
        String acceptHeader = request.getHeader("Accept");
        String contentTypeHeader = request.getHeader("Content-Type");
        return acceptHeader != null && acceptHeader.contains(PAOS_CONTENT_TYPE) && request.getHeader(PAOS_HEADER) != null || contentTypeHeader != null && contentTypeHeader.contains(PAOS_CONTENT_TYPE);
    }

    public static SamlAuthenticationHandler create(HttpFacade facade, SamlDeployment deployment, SamlSessionStore sessionStore) {
        return new EcpAuthenticationHandler(facade, deployment, sessionStore);
    }

    private EcpAuthenticationHandler(HttpFacade facade, SamlDeployment deployment, SamlSessionStore sessionStore) {
        super(facade, deployment, sessionStore);
    }

    @Override
    protected AuthOutcome logoutRequest(LogoutRequestType request, String relayState) {
        throw new RuntimeException("Not supported.");
    }

    @Override
    public AuthOutcome handle(OnSessionCreated onCreateSession) {
        String header = this.facade.getRequest().getHeader(PAOS_HEADER);
        if (header != null) {
            return this.doHandle(new SamlInvocationContext(), onCreateSession);
        }
        try {
            MessageFactory messageFactory = MessageFactory.newInstance();
            SOAPMessage soapMessage = messageFactory.createMessage(null, this.facade.getRequest().getInputStream());
            SOAPBody soapBody = soapMessage.getSOAPBody();
            Node authnRequestNode = soapBody.getFirstChild();
            Document document = DocumentUtil.createDocument();
            document.appendChild(document.importNode(authnRequestNode, true));
            String samlResponse = PostBindingUtil.base64Encode((String)DocumentUtil.asString((Document)document));
            return this.doHandle(new SamlInvocationContext(null, samlResponse, null), onCreateSession);
        }
        catch (Exception e) {
            throw new RuntimeException("Error creating fault message.", e);
        }
    }

    @Override
    protected AbstractInitiateLogin createChallenge() {
        return new AbstractInitiateLogin(this.deployment, this.sessionStore){

            @Override
            protected void sendAuthnRequest(HttpFacade httpFacade, SAML2AuthnRequestBuilder authnRequestBuilder, BaseSAML2BindingBuilder binding) {
                try {
                    MessageFactory messageFactory = MessageFactory.newInstance();
                    SOAPMessage message = messageFactory.createMessage();
                    SOAPEnvelope envelope = message.getSOAPPart().getEnvelope();
                    envelope.addNamespaceDeclaration(EcpAuthenticationHandler.NS_PREFIX_SAML_ASSERTION, JBossSAMLURIConstants.ASSERTION_NSURI.get());
                    envelope.addNamespaceDeclaration(EcpAuthenticationHandler.NS_PREFIX_SAML_PROTOCOL, JBossSAMLURIConstants.PROTOCOL_NSURI.get());
                    envelope.addNamespaceDeclaration(EcpAuthenticationHandler.NS_PREFIX_PAOS_BINDING, JBossSAMLURIConstants.PAOS_BINDING.get());
                    envelope.addNamespaceDeclaration(EcpAuthenticationHandler.NS_PREFIX_PROFILE_ECP, JBossSAMLURIConstants.ECP_PROFILE.get());
                    this.createPaosRequestHeader(envelope);
                    this.createEcpRequestHeader(envelope);
                    SOAPBody body = envelope.getBody();
                    body.addDocument(binding.postBinding(authnRequestBuilder.toDocument()).getDocument());
                    message.writeTo(httpFacade.getResponse().getOutputStream());
                }
                catch (Exception e) {
                    throw new RuntimeException("Could not create AuthnRequest.", e);
                }
            }

            private void createEcpRequestHeader(SOAPEnvelope envelope) throws SOAPException {
                SOAPHeader headers = envelope.getHeader();
                SOAPHeaderElement ecpRequestHeader = headers.addHeaderElement(envelope.createQName(JBossSAMLConstants.REQUEST.get(), EcpAuthenticationHandler.NS_PREFIX_PROFILE_ECP));
                ecpRequestHeader.setMustUnderstand(true);
                ecpRequestHeader.setActor("http://schemas.xmlsoap.org/soap/actor/next");
                ecpRequestHeader.addAttribute(envelope.createName("ProviderName"), this.deployment.getEntityID());
                ecpRequestHeader.addAttribute(envelope.createName("IsPassive"), "0");
                ecpRequestHeader.addChildElement(envelope.createQName("Issuer", EcpAuthenticationHandler.NS_PREFIX_SAML_ASSERTION)).setValue(this.deployment.getEntityID());
                ecpRequestHeader.addChildElement(envelope.createQName("IDPList", EcpAuthenticationHandler.NS_PREFIX_SAML_PROTOCOL)).addChildElement(envelope.createQName("IDPEntry", EcpAuthenticationHandler.NS_PREFIX_SAML_PROTOCOL)).addAttribute(envelope.createName("ProviderID"), this.deployment.getIDP().getEntityID()).addAttribute(envelope.createName("Name"), this.deployment.getIDP().getEntityID()).addAttribute(envelope.createName("Loc"), this.deployment.getIDP().getSingleSignOnService().getRequestBindingUrl());
            }

            private void createPaosRequestHeader(SOAPEnvelope envelope) throws SOAPException {
                SOAPHeader headers = envelope.getHeader();
                SOAPHeaderElement paosRequestHeader = headers.addHeaderElement(envelope.createQName(JBossSAMLConstants.REQUEST.get(), EcpAuthenticationHandler.NS_PREFIX_PAOS_BINDING));
                paosRequestHeader.setMustUnderstand(true);
                paosRequestHeader.setActor("http://schemas.xmlsoap.org/soap/actor/next");
                paosRequestHeader.addAttribute(envelope.createName("service"), JBossSAMLURIConstants.ECP_PROFILE.get());
                paosRequestHeader.addAttribute(envelope.createName("responseConsumerURL"), this.deployment.getAssertionConsumerServiceUrl());
            }
        };
    }
}

