/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.sdjwt;

import org.junit.Assert;
import org.junit.Test;
import org.keycloak.jose.jws.crypto.HashUtils;
import org.keycloak.sdjwt.SdJwtUtils;

public class SdJwtUtilsTest {
    @Test
    public void testHashDisclosure() {
        String expected = "uutlBuYeMDyjLLTpf6Jxi7yNkEF35jdyWMn9U7b_RYY";
        byte[] hash = HashUtils.hash((String)"SHA-256", (byte[])"WyI2cU1RdlJMNWhhaiIsICJmYW1pbHlfbmFtZSIsICJNw7ZiaXVzIl0".getBytes());
        Assert.assertEquals((Object)expected, (Object)SdJwtUtils.encodeNoPad((byte[])hash));
    }

    @Test
    public void testHashDisclosure2() {
        String expected = "w0I8EKcdCtUPkGCNUrfwVp2xEgNjtoIDlOxc9-PlOhs";
        byte[] hash = HashUtils.hash((String)"SHA-256", (byte[])"WyJsa2x4RjVqTVlsR1RQVW92TU5JdkNBIiwgIkZSIl0".getBytes());
        Assert.assertEquals((Object)expected, (Object)SdJwtUtils.encodeNoPad((byte[])hash));
    }

    @Test
    public void testBase64urlEncodedObjectWhiteSpacedJsonArray() {
        String input = "[\"_26bc4LT-ac6q2KI6cBW5es\", \"family_name\", \"M\u00f6bius\"]";
        String expected = "WyJfMjZiYzRMVC1hYzZxMktJNmNCVzVlcyIsICJmYW1pbHlfbmFtZSIsICJNw7ZiaXVzIl0";
        Assert.assertEquals((Object)expected, (Object)SdJwtUtils.encodeNoPad((byte[])input.getBytes()));
    }

    @Test
    public void testBase64urlEncodedObjectNoWhiteSpacedJsonArray() {
        String input = "[\"_26bc4LT-ac6q2KI6cBW5es\",\"family_name\",\"M\u00f6bius\"]";
        String expected = "WyJfMjZiYzRMVC1hYzZxMktJNmNCVzVlcyIsImZhbWlseV9uYW1lIiwiTcO2Yml1cyJd";
        Assert.assertEquals((Object)expected, (Object)SdJwtUtils.encodeNoPad((byte[])input.getBytes()));
    }

    @Test
    public void testBase64urlEncodedArrayElementWhiteSpacedJsonArray() {
        String input = "[\"lklxF5jMYlGTPUovMNIvCA\", \"FR\"]";
        String expected = "WyJsa2x4RjVqTVlsR1RQVW92TU5JdkNBIiwgIkZSIl0";
        Assert.assertEquals((Object)expected, (Object)SdJwtUtils.encodeNoPad((byte[])input.getBytes()));
    }

    @Test
    public void testBase64urlEncodedArrayElementNoWhiteSpacedJsonArray() {
        String input = "[\"lklxF5jMYlGTPUovMNIvCA\",\"FR\"]";
        String expected = "WyJsa2x4RjVqTVlsR1RQVW92TU5JdkNBIiwiRlIiXQ";
        Assert.assertEquals((Object)expected, (Object)SdJwtUtils.encodeNoPad((byte[])input.getBytes()));
    }
}

