/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.sdjwt;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.junit.Assert;
import org.junit.Test;
import org.keycloak.sdjwt.DisclosureSpec;
import org.keycloak.sdjwt.IssuerSignedJWT;
import org.keycloak.sdjwt.SdJwt;
import org.keycloak.sdjwt.TestUtils;

public class SdJWTSamplesTest {
    @Test
    public void testS7_1_FlatSdJwt() {
        JsonNode holderClaimSet = TestUtils.readClaimSet(this.getClass(), "sdjwt/s7-holder-claims.json");
        JsonNode issuerClaimSet = TestUtils.readClaimSet(this.getClass(), "sdjwt/s7-issuer-claims.json");
        ((ObjectNode)holderClaimSet).setAll((ObjectNode)issuerClaimSet);
        DisclosureSpec disclosureSpec = DisclosureSpec.builder().withUndisclosedClaim("address", "2GLC42sKQveCfGfryNRN9w").build();
        SdJwt sdJwt = SdJwt.builder().withDisclosureSpec(disclosureSpec).withClaimSet(holderClaimSet).build();
        IssuerSignedJWT jwt = sdJwt.getIssuerSignedJWT();
        JsonNode expected = TestUtils.readClaimSet(this.getClass(), "sdjwt/s7.1-issuer-payload.json");
        Assert.assertEquals((Object)expected, (Object)jwt.getPayload());
    }

    @Test
    public void testS7_2_StructuredSdJwt() {
        JsonNode holderClaimSet = TestUtils.readClaimSet(this.getClass(), "sdjwt/s7-holder-claims.json");
        JsonNode issuerClaimSet = TestUtils.readClaimSet(this.getClass(), "sdjwt/s7-issuer-claims.json");
        ((ObjectNode)holderClaimSet).setAll((ObjectNode)issuerClaimSet);
        DisclosureSpec addrDisclosureSpec = DisclosureSpec.builder().withUndisclosedClaim("street_address", "2GLC42sKQveCfGfryNRN9w").withUndisclosedClaim("locality", "eluV5Og3gSNII8EYnsxA_A").withUndisclosedClaim("region", "6Ij7tM-a5iVPGboS5tmvVA").withUndisclosedClaim("country", "eI8ZWm9QnKPpNPeNenHdhQ").build();
        JsonNode addressClaimSet = holderClaimSet.get("address");
        SdJwt addrSdJWT = SdJwt.builder().withDisclosureSpec(addrDisclosureSpec).withClaimSet(addressClaimSet).build();
        JsonNode addPayload = addrSdJWT.asNestedPayload();
        ((ObjectNode)holderClaimSet).set("address", addPayload);
        DisclosureSpec disclosureSpec = DisclosureSpec.builder().build();
        SdJwt sdJwt = SdJwt.builder().withDisclosureSpec(disclosureSpec).withClaimSet(holderClaimSet).withNestedSdJwt(addrSdJWT).build();
        IssuerSignedJWT jwt = sdJwt.getIssuerSignedJWT();
        JsonNode expected = TestUtils.readClaimSet(this.getClass(), "sdjwt/s7.2-issuer-payload.json");
        Assert.assertEquals((Object)expected, (Object)jwt.getPayload());
    }

    @Test
    public void testS7_2b_PartialDisclosureOfStructuredSdJwt() {
        JsonNode holderClaimSet = TestUtils.readClaimSet(this.getClass(), "sdjwt/s7-holder-claims.json");
        JsonNode issuerClaimSet = TestUtils.readClaimSet(this.getClass(), "sdjwt/s7-issuer-claims.json");
        ((ObjectNode)holderClaimSet).setAll((ObjectNode)issuerClaimSet);
        DisclosureSpec addrDisclosureSpec = DisclosureSpec.builder().withUndisclosedClaim("street_address", "2GLC42sKQveCfGfryNRN9w").withUndisclosedClaim("locality", "eluV5Og3gSNII8EYnsxA_A").withUndisclosedClaim("region", "6Ij7tM-a5iVPGboS5tmvVA").build();
        JsonNode addressClaimSet = holderClaimSet.get("address");
        SdJwt addrSdJWT = SdJwt.builder().withDisclosureSpec(addrDisclosureSpec).withClaimSet(addressClaimSet).build();
        JsonNode addPayload = addrSdJWT.asNestedPayload();
        ((ObjectNode)holderClaimSet).set("address", addPayload);
        DisclosureSpec disclosureSpec = DisclosureSpec.builder().build();
        SdJwt sdJwt = SdJwt.builder().withDisclosureSpec(disclosureSpec).withClaimSet(holderClaimSet).withNestedSdJwt(addrSdJWT).build();
        IssuerSignedJWT jwt = sdJwt.getIssuerSignedJWT();
        JsonNode expected = TestUtils.readClaimSet(this.getClass(), "sdjwt/s7.2b-issuer-payload.json");
        Assert.assertEquals((Object)expected, (Object)jwt.getPayload());
    }

    @Test
    public void testS7_3_RecursiveDisclosureOfStructuredSdJwt() {
        JsonNode holderClaimSet = TestUtils.readClaimSet(this.getClass(), "sdjwt/s7-holder-claims.json");
        JsonNode issuerClaimSet = TestUtils.readClaimSet(this.getClass(), "sdjwt/s7-issuer-claims.json");
        ((ObjectNode)holderClaimSet).setAll((ObjectNode)issuerClaimSet);
        DisclosureSpec addrDisclosureSpec = DisclosureSpec.builder().withUndisclosedClaim("street_address", "2GLC42sKQveCfGfryNRN9w").withUndisclosedClaim("locality", "eluV5Og3gSNII8EYnsxA_A").withUndisclosedClaim("region", "6Ij7tM-a5iVPGboS5tmvVA").withUndisclosedClaim("country", "eI8ZWm9QnKPpNPeNenHdhQ").build();
        JsonNode addressClaimSet = holderClaimSet.get("address");
        SdJwt addrSdJWT = SdJwt.builder().withDisclosureSpec(addrDisclosureSpec).withClaimSet(addressClaimSet).build();
        JsonNode addPayload = addrSdJWT.asNestedPayload();
        ((ObjectNode)holderClaimSet).set("address", addPayload);
        DisclosureSpec disclosureSpec = DisclosureSpec.builder().withUndisclosedClaim("address", "Qg_O64zqAxe412a108iroA").build();
        SdJwt sdJwt = SdJwt.builder().withDisclosureSpec(disclosureSpec).withClaimSet(holderClaimSet).withNestedSdJwt(addrSdJWT).build();
        IssuerSignedJWT jwt = sdJwt.getIssuerSignedJWT();
        JsonNode expected = TestUtils.readClaimSet(this.getClass(), "sdjwt/s7.3-issuer-payload.json");
        Assert.assertEquals((Object)expected, (Object)jwt.getPayload());
    }
}

