/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.jose.jwe.alg;

import java.security.Key;
import javax.crypto.Cipher;
import org.keycloak.jose.jwe.JWEKeyStorage;
import org.keycloak.jose.jwe.alg.JWEAlgorithmProvider;
import org.keycloak.jose.jwe.enc.JWEEncryptionProvider;

public abstract class KeyEncryptionJWEAlgorithmProvider
implements JWEAlgorithmProvider {
    @Override
    public byte[] decodeCek(byte[] encodedCek, Key privateKey) throws Exception {
        Cipher cipher = this.getCipherProvider();
        cipher.init(2, privateKey);
        return cipher.doFinal(encodedCek);
    }

    @Override
    public byte[] encodeCek(JWEEncryptionProvider encryptionProvider, JWEKeyStorage keyStorage, Key publicKey) throws Exception {
        Cipher cipher = this.getCipherProvider();
        cipher.init(1, publicKey);
        byte[] cekBytes = keyStorage.getCekBytes();
        return cipher.doFinal(cekBytes);
    }

    protected abstract Cipher getCipherProvider() throws Exception;
}

