/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.launcher.core;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.platform.commons.util.ClassLoaderUtils;
import org.junit.platform.commons.util.CollectionUtils;
import org.junit.platform.engine.TestEngine;

class TestEngineFormatter {
    private TestEngineFormatter() {
    }

    static String format(String title, Iterable<TestEngine> testEngines) {
        return TestEngineFormatter.format(title, CollectionUtils.toStream(testEngines));
    }

    private static String format(String title, Stream<TestEngine> testEngines) {
        String details = testEngines.map(engine -> "- %s (%s)".formatted(engine.getId(), String.join((CharSequence)", ", TestEngineFormatter.computeAttributes(engine)))).collect(Collectors.joining("\n"));
        return title + ":" + (String)(details.isEmpty() ? " <none>" : "\n" + details);
    }

    private static List<String> computeAttributes(TestEngine engine) {
        ArrayList<String> attributes = new ArrayList<String>(4);
        engine.getGroupId().ifPresent(groupId -> attributes.add("group ID: " + groupId));
        engine.getArtifactId().ifPresent(artifactId -> attributes.add("artifact ID: " + artifactId));
        engine.getVersion().ifPresent(version -> attributes.add("version: " + version));
        ClassLoaderUtils.getLocation((Object)engine).ifPresent(location -> attributes.add("location: " + String.valueOf(location)));
        return attributes;
    }
}

