/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.launcher.core;

import org.junit.platform.engine.EngineExecutionListener;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.reporting.ReportEntry;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.TestIdentifier;
import org.junit.platform.launcher.TestPlan;

class ExecutionListenerAdapter
implements EngineExecutionListener {
    private final TestPlan testPlan;
    private final TestExecutionListener testExecutionListener;

    ExecutionListenerAdapter(TestPlan testPlan, TestExecutionListener testExecutionListener) {
        this.testPlan = testPlan;
        this.testExecutionListener = testExecutionListener;
    }

    public void dynamicTestRegistered(TestDescriptor testDescriptor) {
        TestIdentifier testIdentifier = TestIdentifier.from(testDescriptor);
        this.testPlan.add(testIdentifier);
        this.testExecutionListener.dynamicTestRegistered(testIdentifier);
    }

    public void executionStarted(TestDescriptor testDescriptor) {
        this.testExecutionListener.executionStarted(this.getTestIdentifier(testDescriptor));
    }

    public void executionSkipped(TestDescriptor testDescriptor, String reason) {
        this.testExecutionListener.executionSkipped(this.getTestIdentifier(testDescriptor), reason);
    }

    public void executionFinished(TestDescriptor testDescriptor, TestExecutionResult testExecutionResult) {
        this.testExecutionListener.executionFinished(this.getTestIdentifier(testDescriptor), testExecutionResult);
    }

    public void reportingEntryPublished(TestDescriptor testDescriptor, ReportEntry entry) {
        this.testExecutionListener.reportingEntryPublished(this.getTestIdentifier(testDescriptor), entry);
    }

    private TestIdentifier getTestIdentifier(TestDescriptor testDescriptor) {
        return this.testPlan.getTestIdentifier(testDescriptor.getUniqueId().toString());
    }
}

